/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.execution.datasources.xml;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public final class JavaXmlSuite {
    private static final int numBooks = 12;
    private static final String booksFile = "src/test/resources/test-data/xml-resources/books.xml";
    private static final String booksFileTag = "book";
    private SparkSession spark;
    private Path tempDir;

    private static void setEnv(String key, String value) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.put(key, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set environment variable", e);
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        JavaXmlSuite.setEnv("SPARK_LOCAL_IP", "127.0.0.1");
        this.spark = SparkSession.builder().master("local[2]").appName("XmlSuite").config("spark.ui.enabled", false).getOrCreate();
        this.spark.sparkContext().setLogLevel("WARN");
        this.tempDir = Files.createTempDirectory("JavaXmlSuite", new FileAttribute[0]);
        this.tempDir.toFile().deleteOnExit();
    }

    @AfterEach
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    private Path getEmptyTempDir() throws IOException {
        return Files.createTempDirectory(this.tempDir, "test", new FileAttribute[0]);
    }

    @Test
    public void testXmlParser() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("rowTag", booksFileTag);
        Dataset df = this.spark.read().options(options).xml(booksFile);
        String prefix = XmlOptions.DEFAULT_ATTRIBUTE_PREFIX();
        long result = df.select(prefix + "id", new String[0]).count();
        Assertions.assertEquals((long)result, (long)12L);
    }

    @Test
    public void testLoad() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("rowTag", booksFileTag);
        Dataset df = this.spark.read().options(options).xml(booksFile);
        long result = df.select("description", new String[0]).count();
        Assertions.assertEquals((long)result, (long)12L);
    }

    @Test
    public void testSave() throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("rowTag", booksFileTag);
        Path booksPath = this.getEmptyTempDir().resolve("booksFile");
        Dataset df = this.spark.read().options(options).xml(booksFile);
        df.select("price", new String[]{"description"}).write().options(options).xml(booksPath.toString());
        Dataset newDf = this.spark.read().options(options).xml(booksPath.toString());
        long result = newDf.select("price", new String[0]).count();
        Assertions.assertEquals((long)result, (long)12L);
    }
}

