/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.util.Map;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import test.org.apache.spark.sql.connector.JavaRangeInputPartition;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;
import test.org.apache.spark.sql.connector.JavaSimpleScanBuilder;

public class JavaSchemaRequiredDataSource
implements TableProvider {
    public boolean supportsExternalMetadata() {
        return true;
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        throw new IllegalArgumentException("requires a user-supplied schema");
    }

    public Table getTable(final StructType schema, Transform[] partitioning, Map<String, String> properties) {
        return new JavaSimpleBatchTable(){

            @Override
            public StructType schema() {
                return schema;
            }

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
                return new MyScanBuilder(schema);
            }
        };
    }

    static class MyScanBuilder
    extends JavaSimpleScanBuilder {
        private StructType schema;

        MyScanBuilder(StructType schema) {
            this.schema = schema;
        }

        @Override
        public StructType readSchema() {
            return this.schema;
        }

        public InputPartition[] planInputPartitions() {
            InputPartition[] partitions = new InputPartition[]{new JavaRangeInputPartition(0, 2)};
            return partitions;
        }
    }
}

