/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaRowSuite {
    private byte byteValue;
    private short shortValue;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private BigDecimal decimalValue;
    private boolean booleanValue;
    private String stringValue;
    private byte[] binaryValue;
    private Date dateValue;
    private Timestamp timestampValue;

    @BeforeEach
    public void setUp() {
        this.byteValue = (byte)127;
        this.shortValue = Short.MAX_VALUE;
        this.intValue = Integer.MAX_VALUE;
        this.longValue = Long.MAX_VALUE;
        this.floatValue = Float.MAX_VALUE;
        this.doubleValue = Double.MAX_VALUE;
        this.decimalValue = new BigDecimal("1.7976931348623157E328");
        this.booleanValue = true;
        this.stringValue = "this is a string";
        this.binaryValue = this.stringValue.getBytes(StandardCharsets.UTF_8);
        this.dateValue = Date.valueOf("2014-06-30");
        this.timestampValue = Timestamp.valueOf("2014-06-30 09:20:00.0");
    }

    @Test
    public void constructSimpleRow() {
        Row simpleRow = RowFactory.create((Object[])new Object[]{this.byteValue, this.byteValue, this.shortValue, this.shortValue, this.intValue, this.intValue, this.longValue, this.longValue, Float.valueOf(this.floatValue), Float.valueOf(this.floatValue), this.doubleValue, this.doubleValue, this.decimalValue, this.booleanValue, this.booleanValue, this.stringValue, this.binaryValue, this.dateValue, this.timestampValue, null});
        Assertions.assertEquals((byte)this.byteValue, (byte)simpleRow.getByte(0));
        Assertions.assertEquals((Object)this.byteValue, (Object)simpleRow.get(0));
        Assertions.assertEquals((byte)this.byteValue, (byte)simpleRow.getByte(1));
        Assertions.assertEquals((Object)this.byteValue, (Object)simpleRow.get(1));
        Assertions.assertEquals((short)this.shortValue, (short)simpleRow.getShort(2));
        Assertions.assertEquals((Object)this.shortValue, (Object)simpleRow.get(2));
        Assertions.assertEquals((short)this.shortValue, (short)simpleRow.getShort(3));
        Assertions.assertEquals((Object)this.shortValue, (Object)simpleRow.get(3));
        Assertions.assertEquals((int)this.intValue, (int)simpleRow.getInt(4));
        Assertions.assertEquals((Object)this.intValue, (Object)simpleRow.get(4));
        Assertions.assertEquals((int)this.intValue, (int)simpleRow.getInt(5));
        Assertions.assertEquals((Object)this.intValue, (Object)simpleRow.get(5));
        Assertions.assertEquals((long)this.longValue, (long)simpleRow.getLong(6));
        Assertions.assertEquals((Object)this.longValue, (Object)simpleRow.get(6));
        Assertions.assertEquals((long)this.longValue, (long)simpleRow.getLong(7));
        Assertions.assertEquals((Object)this.longValue, (Object)simpleRow.get(7));
        Assertions.assertEquals((float)this.floatValue, (float)simpleRow.getFloat(8), (float)0.0f);
        Assertions.assertEquals((Object)Float.valueOf(this.floatValue), (Object)simpleRow.get(8));
        Assertions.assertEquals((float)this.floatValue, (float)simpleRow.getFloat(9), (float)0.0f);
        Assertions.assertEquals((Object)Float.valueOf(this.floatValue), (Object)simpleRow.get(9));
        Assertions.assertEquals((double)this.doubleValue, (double)simpleRow.getDouble(10), (double)0.0);
        Assertions.assertEquals((Object)this.doubleValue, (Object)simpleRow.get(10));
        Assertions.assertEquals((double)this.doubleValue, (double)simpleRow.getDouble(11), (double)0.0);
        Assertions.assertEquals((Object)this.doubleValue, (Object)simpleRow.get(11));
        Assertions.assertEquals((Object)this.decimalValue, (Object)simpleRow.get(12));
        Assertions.assertEquals((Object)this.booleanValue, (Object)simpleRow.getBoolean(13));
        Assertions.assertEquals((Object)this.booleanValue, (Object)simpleRow.get(13));
        Assertions.assertEquals((Object)this.booleanValue, (Object)simpleRow.getBoolean(14));
        Assertions.assertEquals((Object)this.booleanValue, (Object)simpleRow.get(14));
        Assertions.assertEquals((Object)this.stringValue, (Object)simpleRow.getString(15));
        Assertions.assertEquals((Object)this.stringValue, (Object)simpleRow.get(15));
        Assertions.assertEquals((Object)this.binaryValue, (Object)simpleRow.get(16));
        Assertions.assertEquals((Object)this.dateValue, (Object)simpleRow.get(17));
        Assertions.assertEquals((Object)this.timestampValue, (Object)simpleRow.get(18));
        Assertions.assertTrue((boolean)simpleRow.isNullAt(19));
        Assertions.assertNull((Object)simpleRow.get(19));
    }

    @Test
    public void constructComplexRow() {
        List<String> simpleStringArray = Arrays.asList(this.stringValue + " (1)", this.stringValue + " (2)", this.stringValue + "(3)");
        HashMap<CallSite, Long> simpleMap = new HashMap<CallSite, Long>();
        simpleMap.put((CallSite)((Object)(this.stringValue + " (1)")), this.longValue);
        simpleMap.put((CallSite)((Object)(this.stringValue + " (2)")), this.longValue - 1L);
        simpleMap.put((CallSite)((Object)(this.stringValue + " (3)")), this.longValue - 2L);
        Row simpleStruct = RowFactory.create((Object[])new Object[]{this.doubleValue, this.stringValue, this.timestampValue, null});
        List<Map> arrayOfMaps = Arrays.asList(simpleMap);
        List<Row> arrayOfRows = Arrays.asList(simpleStruct);
        HashMap<List<Row>, Row> complexMap = new HashMap<List<Row>, Row>();
        complexMap.put(arrayOfRows, simpleStruct);
        Row complexStruct = RowFactory.create((Object[])new Object[]{simpleStringArray, simpleMap, simpleStruct, arrayOfMaps, arrayOfRows, complexMap, null});
        Assertions.assertEquals(simpleStringArray, (Object)complexStruct.get(0));
        Assertions.assertEquals(simpleMap, (Object)complexStruct.get(1));
        Assertions.assertEquals((Object)simpleStruct, (Object)complexStruct.get(2));
        Assertions.assertEquals(arrayOfMaps, (Object)complexStruct.get(3));
        Assertions.assertEquals(arrayOfRows, (Object)complexStruct.get(4));
        Assertions.assertEquals(complexMap, (Object)complexStruct.get(5));
        Assertions.assertNull((Object)complexStruct.get(6));
        Row complexRow = RowFactory.create((Object[])new Object[]{arrayOfMaps, arrayOfRows, complexMap, complexStruct});
        Assertions.assertEquals(arrayOfMaps, (Object)complexRow.get(0));
        Assertions.assertEquals(arrayOfRows, (Object)complexRow.get(1));
        Assertions.assertEquals(complexMap, (Object)complexRow.get(2));
        Assertions.assertEquals((Object)complexStruct, (Object)complexRow.get(3));
    }
}

