/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.expressions.javalang.typed;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;
import test.org.apache.spark.sql.JavaDatasetAggregatorSuiteBase;

public class Java8DatasetAggregatorSuite
extends JavaDatasetAggregatorSuiteBase {
    @Test
    public void testTypedAggregationAverage() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset aggregated = grouped.agg(typed.avg((MapFunction & Serializable)v -> (Integer)v._2() * 2));
        Assertions.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3.0), new Tuple2((Object)"b", (Object)6.0)), (Object)aggregated.collectAsList());
    }

    @Test
    public void testTypedAggregationCount() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset aggregated = grouped.agg(typed.count((MapFunction & Serializable)v -> v));
        Assertions.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)2L), new Tuple2((Object)"b", (Object)1L)), (Object)aggregated.collectAsList());
    }

    @Test
    public void testTypedAggregationSumDouble() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset aggregated = grouped.agg(typed.sum((MapFunction & Serializable)v -> (double)((Integer)v._2())));
        Assertions.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3.0), new Tuple2((Object)"b", (Object)3.0)), (Object)aggregated.collectAsList());
    }

    @Test
    public void testTypedAggregationSumLong() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset aggregated = grouped.agg(typed.sumLong((MapFunction & Serializable)v -> (long)((Integer)v._2())));
        Assertions.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3L), new Tuple2((Object)"b", (Object)3L)), (Object)aggregated.collectAsList());
    }
}

