/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.MultiBatchExecutor;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.SingleBatchExecutor;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation$;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.SlowSQLTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@SlowSQLTest
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0013'\u0001EBQA\u000e\u0001\u0005\u0002]2Q!\u000f\u0001\u0002\u0002iBQA\u000e\u0002\u0005\u0002\u0005Cq\u0001\u0012\u0002A\u0002\u0013\u0005Q\tC\u0004J\u0005\u0001\u0007I\u0011\u0001&\t\rA\u0013\u0001\u0015)\u0003G\u0011\u0015)&A\"\u0001W\u0011\u0015I'A\"\u0001k\u0011\u0015\u0001(A\"\u0001r\u0011\u0015Q(\u0001\"\u0001|\r\u0011a\b\u0001A?\t\rYZA\u0011AA\u0006\u0011\u001d\tya\u0003C!\u0003#Aq!a\b\f\t\u0003\n\t\u0003\u0003\u0004j\u0017\u0011\u0005\u00131\u0006\u0005\u0006+.!\tE\u0016\u0005\b\u0003_YA\u0011IA\u0019\u0011\u0019\tyd\u0003C!w\"9\u0011\u0011I\u0006\u0005\n\u0005\r\u0003\"\u00029\f\t\u0003\nhABA%\u0001\u0001\tY\u0005\u0003\u00047+\u0011\u0005\u0011q\f\u0005\b\u0003G*B\u0011IA3\u0011\u001d\ti'\u0006C!\u0003_2a!! \u0001\u0001\u0005}\u0004B\u0002\u001c\u001a\t\u0003\t\t\t\u0003\u0006\u0002\u0006fA)\u0019!C\u0005\u0003\u000fCQ!V\r\u0005BYCa![\r\u0005B\u0005=\u0005\"\u00029\u001a\t\u0003\n\b\"\u0002>\u001a\t\u0003Z\bbBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!!2\u0001\t\u0013\t9\rC\u0004\u0002L\u0002!I!!4\u00031Q\u0013\u0018nZ4fe\u00063\u0018-\u001b7bE2,gj\\<Tk&$XM\u0003\u0002(Q\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0002\"a\r\u001b\u000e\u0003\u0019J!!\u000e\u0014\u0003)\u0019KG.Z*ue\u0016\fWnU8ve\u000e,G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u00024\u0001\t)B+Z:u\t\u0006$\u0018M\u0012:b[\u0016\u0004&o\u001c<jI\u0016\u00148C\u0001\u0002<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMR\t!\t\u0005\u0002D\u00055\t\u0001!A\u0007dkJ\u0014XM\u001c;PM\u001a\u001cX\r^\u000b\u0002\rB\u0011AhR\u0005\u0003\u0011v\u0012A\u0001T8oO\u0006\t2-\u001e:sK:$xJ\u001a4tKR|F%Z9\u0015\u0005-s\u0005C\u0001\u001fM\u0013\tiUH\u0001\u0003V]&$\bbB(\u0006\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0014AD2veJ,g\u000e^(gMN,G\u000f\t\u0015\u0003\rI\u0003\"\u0001P*\n\u0005Qk$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\tQ|GIR\u000b\u0002/B\u0011\u0001L\u001a\b\u00033\u0012t!AW2\u000f\u0005m\u0013gB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\ty\u0006'\u0001\u0004=e>|GOP\u0005\u0002_%\u0011QFL\u0005\u0003W1J!!\u000b\u0016\n\u0005\u0015D\u0013a\u00029bG.\fw-Z\u0005\u0003O\"\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005\u0015D\u0013\u0001G5oGJ,W.\u001a8u\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiR\u00111j\u001b\u0005\u0006Y\"\u0001\r!\\\u0001\u000b]Vlg*Z<S_^\u001c\bC\u0001\u001fo\u0013\tyWHA\u0002J]R\f!b]8ve\u000e,g*Y7f+\u0005\u0011\bCA:x\u001d\t!X\u000f\u0005\u0002^{%\u0011a/P\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002w{\u0005)!/Z:fiR\t1J\u0001\u0006UKN$8k\\;sG\u0016\u001c2a\u0003\"\u007f!\ry\u0018qA\u0007\u0003\u0003\u0003Q1aJA\u0002\u0015\r\t)\u0001K\u0001\nKb,7-\u001e;j_:LA!!\u0003\u0002\u0002\t11k\\;sG\u0016$\"!!\u0004\u0011\u0005\r[\u0011!C4fi>3gm]3u+\t\t\u0019\u0002E\u0003=\u0003+\tI\"C\u0002\u0002\u0018u\u0012aa\u00149uS>t\u0007cA@\u0002\u001c%!\u0011QDA\u0001\u0005\u0019yeMZ:fi\u0006Aq-\u001a;CCR\u001c\u0007\u000eF\u0003X\u0003G\t9\u0003C\u0004\u0002&9\u0001\r!a\u0005\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005%b\u00021\u0001\u0002\u001a\u0005\u0019QM\u001c3\u0015\u0007-\u000bi\u0003C\u0003m\u001f\u0001\u0007Q.\u0001\u0004tG\",W.Y\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u001f\u0003o\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003\u0011\u0019Ho\u001c9\u0002\u001d\u001d,Go\u00144gg\u0016$h+\u00197vKR\u0019a)!\u0012\t\u000f\u0005\u001d3\u00031\u0001\u0002\u001a\u00051qN\u001a4tKR\u0014a\u0004V3tiN{WO]2f/&$\b.\u00113nSN\u001c\u0018n\u001c8D_:$(o\u001c7\u0014\u000bU\ti!!\u0014\u0011\t\u0005=\u00131L\u0007\u0003\u0003#R1aJA*\u0015\u0011\t)&a\u0016\u0002\tI,\u0017\r\u001a\u0006\u0004\u00033B\u0013!C2p]:,7\r^8s\u0013\u0011\ti&!\u0015\u00031M+\b\u000f]8siN\fE-\\5tg&|gnQ8oiJ|G\u000e\u0006\u0002\u0002bA\u00111)F\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003O\u0002B!a\u0014\u0002j%!\u00111NA)\u0005%\u0011V-\u00193MS6LG/\u0001\u0007mCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002r\u0005U\u0014\u0011\u0010\t\u0005\u0003\u001f\n\u0019(\u0003\u0003\u0002\u001e\u0005E\u0003bBA<1\u0001\u0007\u0011\u0011O\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0002|a\u0001\r!a\u001a\u0002\u000b1LW.\u001b;\u0003)Q+7\u000f^'jGJ|')\u0019;dQN#(/Z1n'\tI\"\t\u0006\u0002\u0002\u0004B\u00111)G\u0001\r[\u0016lwN]=TiJ,\u0017-\\\u000b\u0003\u0003\u0013\u0003Ba`AF\r&!\u0011QRA\u0001\u00051iU-\\8ssN#(/Z1n)\rY\u0015\u0011\u0013\u0005\u0006Yv\u0001\r!\\\u0001\u0015i\u0016\u001cHoV5uQ\u000e{gNZ5h\u001b\u0006$(/\u001b=\u0015\t\u0005]\u0015\u0011\u0016\u000b\u0004\u0017\u0006e\u0005\u0002CANA\u0011\u0005\r!!(\u0002\u000fQ,7\u000f\u001e$v]B)A(a(\u0002$&\u0019\u0011\u0011U\u001f\u0003\u0011q\u0012\u0017P\\1nKz\u00022\u0001PAS\u0013\r\t9+\u0010\u0002\u0004\u0003:L\bBBAVA\u0001\u0007!/\u0001\u0005uKN$h*Y7f\u0003\t\n7o]3siF+XM]=Vg&twMU5hQR\u0014\u0015\r^2i\u000bb,7-\u001e;peR)1*!-\u00026\"1\u00111W\u0011A\u0002\t\u000b!\u0002^3tiN{WO]2f\u0011\u001d\t9,\ta\u0001\u0003s\u000bQ!];fef\u00042aMA^\u0013\r\tiL\n\u0002\u000f'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0003\r\n7o]3siF+XM]=Vg&twmU5oO2,')\u0019;dQ\u0016CXmY;u_J$2aSAb\u0011\u001d\t9L\ta\u0001\u0003s\u000b!%Y:tKJ$\u0018+^3ssV\u001b\u0018N\\4Nk2$\u0018NQ1uG\",\u00050Z2vi>\u0014HcA&\u0002J\"9\u0011qW\u0012A\u0002\u0005e\u0016AF4fi6K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0015\t\u0005=\u0017Q\u001b\t\u0004\u007f\u0006E\u0017\u0002BAj\u0003\u0003\u00111#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:Dq!a.%\u0001\u0004\tI\fK\u0002\u0001\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?T\u0013\u0001\u0002;bONLA!a9\u0002^\nY1\u000b\\8x'FcE+Z:u\u0001")
public class TriggerAvailableNowSuite
extends FileStreamSourceTest {
    public void testWithConfigMatrix(String testName, Function0<Object> testFun) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)useWrapper -> {
            this.test(testName + " (using wrapper: " + BoxesRunTime.unboxToBoolean((Object)useWrapper) + ")", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_TRIGGER_AVAILABLE_NOW_WRAPPER_ENABLED().key()), (Object)Boolean.toString(useWrapper))}), testFun$1), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            return BoxedUnit.UNIT;
        });
    }

    private void assertQueryUsingRightBatchExecutor(TestDataFrameProvider testSource, StreamingQuery query) {
        boolean useWrapper = BoxesRunTime.unboxToBoolean((Object)query.sparkSession().conf().get(SQLConf$.MODULE$.STREAMING_TRIGGER_AVAILABLE_NOW_WRAPPER_ENABLED()));
        if (useWrapper) {
            this.assertQueryUsingMultiBatchExecutor(query);
            return;
        }
        TestDataFrameProvider testDataFrameProvider = testSource;
        if (testDataFrameProvider instanceof TestMicroBatchStream) {
            this.assertQueryUsingMultiBatchExecutor(query);
            return;
        }
        this.assertQueryUsingSingleBatchExecutor(query);
    }

    private void assertQueryUsingSingleBatchExecutor(StreamingQuery query) {
        TriggerExecutor $org_scalatest_assert_macro_left = this.getMicroBatchExecution(query).triggerExecutor();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.streaming.SingleBatchExecutor", $org_scalatest_assert_macro_left instanceof SingleBatchExecutor, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
    }

    private void assertQueryUsingMultiBatchExecutor(StreamingQuery query) {
        TriggerExecutor $org_scalatest_assert_macro_left = this.getMicroBatchExecution(query).triggerExecutor();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.streaming.MultiBatchExecutor", $org_scalatest_assert_macro_left instanceof MultiBatchExecutor, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
    }

    private MicroBatchExecution getMicroBatchExecution(StreamingQuery query) {
        if (query instanceof StreamingQueryWrapper) {
            return (MicroBatchExecution)((StreamingQueryWrapper)query).streamingQuery();
        }
        return (MicroBatchExecution)query;
    }

    private static final File createFile$1(int data, File src$1, ObjectRef lastFileModTime$1) {
        File file = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src$1, data + ".txt"), Integer.toString(data));
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return file;
    }

    private static final StreamingQuery startQuery$1(Dataset df1$1, Dataset df2$1, String checkpoint$1, String targetDir$1) {
        return df1$1.union(df2$1).writeStream().format("parquet").trigger(Trigger.AvailableNow()).option("checkpointLocation", checkpoint$1).start(targetDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(StreamingQueryProgress x$2) {
        return x$2.numInputRows() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$6(TestDataFrameProvider testSource$1, SourceProgress x$3) {
        return x$3.description().startsWith(testSource$1.sourceName());
    }

    public static final /* synthetic */ String $anonfun$new$8(int x$4) {
        return Integer.toString(x$4);
    }

    public static final /* synthetic */ boolean $anonfun$new$9(StreamingQueryProgress x$5) {
        return x$5.numInputRows() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$11(TestDataFrameProvider testSource$1, SourceProgress x$6) {
        return x$6.description().startsWith(testSource$1.sourceName());
    }

    public static final /* synthetic */ String $anonfun$new$13(int x$7) {
        return Integer.toString(x$7);
    }

    public static final /* synthetic */ void $anonfun$new$3(TriggerAvailableNowSuite $this, TestDataFrameProvider testSource$1, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        String targetDir = new File(target, "data").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        Dataset df1 = $this.spark().readStream().option("maxFilesPerTrigger", 1L).text(src.getCanonicalPath());
        Dataset df2 = testSource$1.toDF().selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(value as string)"}));
        testSource$1.incrementAvailableOffset(3);
        TriggerAvailableNowSuite.createFile$1(7, src, lastFileModTime);
        TriggerAvailableNowSuite.createFile$1(8, src, lastFileModTime);
        TriggerAvailableNowSuite.createFile$1(9, src, lastFileModTime);
        StreamingQuery q = TriggerAvailableNowSuite.startQuery$1(df1, df2, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(TriggerAvailableNowSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$4(x$2)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress()), (Function1 & Serializable)p -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])p.sources()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$6(testSource$1, x$3))), "scala.Predef.refArrayOps[org.apache.spark.sql.streaming.SourceProgress](p.sources).exists(((x$3: org.apache.spark.sql.streaming.SourceProgress) => x$3.description.startsWith(testSource.sourceName)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            });
            $this.assertQueryUsingRightBatchExecutor(testSource$1, q);
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * from parquet.`" + targetDir + "`")), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 7, 8, 9})).map((Function1 & Serializable)x$4 -> TriggerAvailableNowSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x$4))), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q.stop();
        }
        testSource$1.incrementAvailableOffset(3);
        TriggerAvailableNowSuite.createFile$1(10, src, lastFileModTime);
        TriggerAvailableNowSuite.createFile$1(11, src, lastFileModTime);
        TriggerAvailableNowSuite.createFile$1(12, src, lastFileModTime);
        StreamingQuery q2 = TriggerAvailableNowSuite.startQuery$1(df1, df2, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(TriggerAvailableNowSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$9(x$5)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress()), (Function1 & Serializable)p -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])p.sources()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$11(testSource$1, x$6))), "scala.Predef.refArrayOps[org.apache.spark.sql.streaming.SourceProgress](p.sources).exists(((x$6: org.apache.spark.sql.streaming.SourceProgress) => x$6.description.startsWith(testSource.sourceName)))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            });
            $this.assertQueryUsingRightBatchExecutor(testSource$1, q2);
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * from parquet.`" + targetDir + "`")), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12).map((Function1 & Serializable)x$7 -> TriggerAvailableNowSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)x$7))), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q2.stop();
        }
    }

    private static final StreamingQuery startQuery$2(Dataset df$1, String tableName$1) {
        return df$1.writeStream().format("memory").queryName(tableName$1).trigger(Trigger.AvailableNow()).start();
    }

    public static final /* synthetic */ boolean $anonfun$new$17(StreamingQueryProgress x$8) {
        return x$8.numInputRows() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(TestDataFrameProvider testSource$2, SourceProgress x$9) {
        return x$9.description().startsWith(testSource$2.sourceName());
    }

    public static final /* synthetic */ boolean $anonfun$new$21(StreamingQueryProgress x$10) {
        return x$10.numInputRows() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(TestDataFrameProvider testSource$2, SourceProgress x$11) {
        return x$11.description().startsWith(testSource$2.sourceName());
    }

    public TriggerAvailableNowSuite() {
        new .colon.colon((Object)new TestSource(this), (List)new .colon.colon((Object)new TestSourceWithAdmissionControl(this), (List)new .colon.colon((Object)new TestMicroBatchStream(this), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testSource -> {
            this.testWithConfigMatrix("TriggerAvailableNow for multiple sources with " + testSource.getClass(), (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
                testSource.reset();
                $this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(src, target) -> {
                    TriggerAvailableNowSuite.$anonfun$new$3($this, testSource, src, target);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)new TestSource(this), (List)new .colon.colon((Object)new TestSourceWithAdmissionControl(this), (List)new .colon.colon((Object)new TestMicroBatchStream(this), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testSource -> {
            this.testWithConfigMatrix("TriggerAvailableNow for single source with " + testSource.getClass(), (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
                testSource.reset();
                String tableName = "trigger_available_now_test_table";
                $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Dataset<Row> df = testSource.toDF();
                    testSource.incrementAvailableOffset(3);
                    StreamingQuery q = TriggerAvailableNowSuite.startQuery$2(df, tableName);
                    try {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(TriggerAvailableNowSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
                        int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$17(x$8)));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress()), (Function1 & Serializable)p -> {
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])p.sources()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$19(testSource, x$9))), "scala.Predef.refArrayOps[org.apache.spark.sql.streaming.SourceProgress](p.sources).exists(((x$9: org.apache.spark.sql.streaming.SourceProgress) => x$9.description.startsWith(testSource.sourceName)))", Prettifier$.MODULE$.default());
                            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
                        });
                        $this.assertQueryUsingRightBatchExecutor(testSource, q);
                        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(tableName), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3), $this.testImplicits().newIntEncoder()).toDF());
                    }
                    finally {
                        q.stop();
                    }
                    testSource.incrementAvailableOffset(3);
                    StreamingQuery q2 = TriggerAvailableNowSuite.startQuery$2(df, tableName);
                    try {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(TriggerAvailableNowSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
                        int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$21(x$10)));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress()), (Function1 & Serializable)p -> {
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])p.sources()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TriggerAvailableNowSuite.$anonfun$new$23(testSource, x$11))), "scala.Predef.refArrayOps[org.apache.spark.sql.streaming.SourceProgress](p.sources).exists(((x$11: org.apache.spark.sql.streaming.SourceProgress) => x$11.description.startsWith(testSource.sourceName)))", Prettifier$.MODULE$.default());
                            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                        });
                        $this.assertQueryUsingRightBatchExecutor(testSource, q2);
                        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(tableName), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6), $this.testImplicits().newIntEncoder()).toDF());
                    }
                    finally {
                        q2.stop();
                    }
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public abstract class TestDataFrameProvider {
        private volatile long currentOffset;

        public long currentOffset() {
            return this.currentOffset;
        }

        public void currentOffset_$eq(long x$1) {
            this.currentOffset = x$1;
        }

        public abstract Dataset<Row> toDF();

        public abstract void incrementAvailableOffset(int var1);

        public abstract String sourceName();

        public void reset() {
            this.currentOffset_$eq(0L);
        }

        public /* synthetic */ TriggerAvailableNowSuite org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestDataFrameProvider$$$outer() {
            return TriggerAvailableNowSuite.this;
        }

        public TestDataFrameProvider() {
            if (TriggerAvailableNowSuite.this == null) {
                throw null;
            }
            this.currentOffset = 0L;
        }
    }

    public class TestMicroBatchStream
    extends TestDataFrameProvider {
        private MemoryStream<Object> memoryStream;
        private volatile boolean bitmap$0;

        private MemoryStream<Object> memoryStream$lzycompute() {
            TestMicroBatchStream testMicroBatchStream = this;
            synchronized (testMicroBatchStream) {
                if (!this.bitmap$0) {
                    this.memoryStream = new MemoryStream(0, this.org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestMicroBatchStream$$$outer().spark().sqlContext(), MemoryStream$.MODULE$.apply$default$3(), this.org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestMicroBatchStream$$$outer().testImplicits().newLongEncoder());
                    this.bitmap$0 = true;
                }
            }
            return this.memoryStream;
        }

        private MemoryStream<Object> memoryStream() {
            if (!this.bitmap$0) {
                return this.memoryStream$lzycompute();
            }
            return this.memoryStream;
        }

        @Override
        public Dataset<Row> toDF() {
            return this.memoryStream().toDF();
        }

        @Override
        public void incrementAvailableOffset(int numNewRows) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numNewRows).foreach((Function1 & Serializable)x$1 -> TestMicroBatchStream.$anonfun$incrementAvailableOffset$1(this, BoxesRunTime.unboxToInt((Object)x$1)));
        }

        @Override
        public String sourceName() {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(MemoryStream$.MODULE$.getClass().getSimpleName()), 1);
        }

        @Override
        public void reset() {
            super.reset();
            this.memoryStream().reset();
        }

        public /* synthetic */ TriggerAvailableNowSuite org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestMicroBatchStream$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ Offset $anonfun$incrementAvailableOffset$1(TestMicroBatchStream $this, int x$1) {
            int n = x$1;
            $this.currentOffset_$eq($this.currentOffset() + 1L);
            return $this.memoryStream().addData((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{$this.currentOffset()}));
        }

        public TestMicroBatchStream(TriggerAvailableNowSuite $outer) {
        }
    }

    public class TestSource
    extends TestDataFrameProvider
    implements Source {
        public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
            Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
        }

        public Offset initialOffset() {
            return Source.initialOffset$((Source)this);
        }

        public Offset deserializeOffset(String json) {
            return Source.deserializeOffset$((Source)this, (String)json);
        }

        public void commit(Offset end) {
            Source.commit$((Source)this, (Offset)end);
        }

        public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
            if (this.currentOffset() <= 0L) {
                return None$.MODULE$;
            }
            return new Some((Object)new LongOffset(this.currentOffset()));
        }

        public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
            if (this.currentOffset() == 0L) {
                this.currentOffset_$eq(this.getOffsetValue(end));
            }
            long x$1 = BoxesRunTime.unboxToLong((Object)start.map((Function1 & Serializable)offset -> BoxesRunTime.boxToLong((long)this.getOffsetValue(offset))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + 1L;
            long x$2 = this.getOffsetValue(end) + 1L;
            long x$3 = 1L;
            None$ x$4 = None$.MODULE$;
            boolean x$5 = true;
            Seq x$6 = Range$.MODULE$.apply$default$5();
            Range plan = new Range(x$1, x$2, 1L, (Option)x$4, x$6, true);
            return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestSource$$$outer().spark(), (LogicalPlan)plan);
        }

        @Override
        public void incrementAvailableOffset(int numNewRows) {
            this.currentOffset_$eq(this.currentOffset() + (long)numNewRows);
        }

        @Override
        public Dataset<Row> toDF() {
            return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestSource$$$outer().spark(), (LogicalPlan)StreamingExecutionRelation$.MODULE$.apply((Source)this, this.org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestSource$$$outer().spark()));
        }

        public StructType schema() {
            return new StructType().add("value", (DataType)LongType$.MODULE$);
        }

        public void stop() {
        }

        private long getOffsetValue(org.apache.spark.sql.execution.streaming.Offset offset) {
            org.apache.spark.sql.execution.streaming.Offset offset2 = offset;
            if (offset2 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset2;
                return LongOffset$.MODULE$.apply(serializedOffset).offset();
            }
            if (offset2 instanceof LongOffset) {
                LongOffset longOffset = (LongOffset)offset2;
                return longOffset.offset();
            }
            throw new IllegalArgumentException("incorrect offset type: " + offset);
        }

        @Override
        public String sourceName() {
            return this.getClass().getName();
        }

        public /* synthetic */ TriggerAvailableNowSuite org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestSource$$$outer() {
            return this.$outer;
        }

        public TestSource(TriggerAvailableNowSuite $outer) {
            Source.$init$((Source)this);
        }
    }

    public class TestSourceWithAdmissionControl
    extends TestSource
    implements SupportsAdmissionControl {
        public Offset reportLatestOffset() {
            return super.reportLatestOffset();
        }

        public ReadLimit getDefaultReadLimit() {
            return ReadLimit.maxRows((long)1L);
        }

        public Offset latestOffset(Offset startOffset, ReadLimit limit) {
            Option<org.apache.spark.sql.execution.streaming.Offset> currentOffset;
            Option<org.apache.spark.sql.execution.streaming.Offset> $org_scalatest_assert_macro_left = currentOffset = this.getOffset();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the latestOffset should be called after incrementAvailableOffset", Prettifier$.MODULE$.default(), new Position("TriggerAvailableNowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            return (Offset)currentOffset.get();
        }

        public /* synthetic */ TriggerAvailableNowSuite org$apache$spark$sql$streaming$TriggerAvailableNowSuite$TestSourceWithAdmissionControl$$$outer() {
            return this.$outer;
        }

        public TestSourceWithAdmissionControl(TriggerAvailableNowSuite $outer) {
            super($outer);
        }
    }
}

