/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StateStoreTestsHelper$ {
    public static final StateStoreTestsHelper$ MODULE$ = new StateStoreTestsHelper$();
    private static final StructType keySchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("key1", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("key2", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
    private static final StructType valueSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
    private static final UnsafeProjection keyProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    private static final UnsafeProjection prefixKeyProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{StringType$.MODULE$}));
    private static final UnsafeProjection valueProj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}));

    public StructType keySchema() {
        return keySchema;
    }

    public StructType valueSchema() {
        return valueSchema;
    }

    public UnsafeProjection keyProj() {
        return keyProj;
    }

    public UnsafeProjection prefixKeyProj() {
        return prefixKeyProj;
    }

    public UnsafeProjection valueProj() {
        return valueProj;
    }

    public UnsafeRow dataToPrefixKeyRow(String s) {
        return this.prefixKeyProj().apply((InternalRow)new GenericInternalRow(new Object[]{UTF8String.fromString((String)s)})).copy();
    }

    public UnsafeRow dataToKeyRow(String s, int i) {
        return this.keyProj().apply((InternalRow)new GenericInternalRow(new Object[]{UTF8String.fromString((String)s), BoxesRunTime.boxToInteger((int)i)})).copy();
    }

    public UnsafeRow dataToValueRow(int i) {
        return this.valueProj().apply((InternalRow)new GenericInternalRow(new Object[]{BoxesRunTime.boxToInteger((int)i)})).copy();
    }

    public Tuple2<String, Object> keyRowToData(UnsafeRow row) {
        return new Tuple2((Object)row.getUTF8String(0).toString(), (Object)BoxesRunTime.boxToInteger((int)row.getInt(1)));
    }

    public int valueRowToData(UnsafeRow row) {
        return row.getInt(0);
    }

    public Tuple2<Tuple2<String, Object>, Object> rowPairToDataPair(UnsafeRowPair row) {
        return new Tuple2(this.keyRowToData(row.key()), (Object)BoxesRunTime.boxToInteger((int)this.valueRowToData(row.value())));
    }

    public Set<Tuple2<Tuple2<String, Object>, Object>> rowPairsToDataSet(Iterator<UnsafeRowPair> iterator) {
        return iterator.map((Function1 & Serializable)row -> MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
    }

    public void remove(StateStore store, Function1<Tuple2<String, Object>, Object> condition) {
        store.iterator().foreach((Function1 & Serializable)rowPair -> {
            StateStoreTestsHelper$.$anonfun$remove$1(condition, store, rowPair);
            return BoxedUnit.UNIT;
        });
    }

    public void put(StateStore store, String key1, int key2, int value) {
        store.put(this.dataToKeyRow(key1, key2), this.dataToValueRow(value));
    }

    public Option<Object> get(ReadStateStore store, String key1, int key2) {
        return Option$.MODULE$.apply((Object)store.get(this.dataToKeyRow(key1, key2))).map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row)));
    }

    public String newDir() {
        return Utils$.MODULE$.createTempDir().toString();
    }

    public static final /* synthetic */ void $anonfun$remove$1(Function1 condition$1, StateStore store$8, UnsafeRowPair rowPair) {
        if (BoxesRunTime.unboxToBoolean((Object)condition$1.apply(MODULE$.keyRowToData(rowPair.key())))) {
            store$8.remove(rowPair.key());
            return;
        }
    }

    private StateStoreTestsHelper$() {
    }
}

