/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.optimizer.InferFiltersFromConstraints$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PushableColumnAndNestedColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilterSuite;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.tags.ExtendedSQLTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005u4A\u0001B\u0003\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C);!)!\u0005\u0001C!G\t!\u0002+\u0019:rk\u0016$h+\r$jYR,'oU;ji\u0016T!AB\u0004\u0002\u000fA\f'/];fi*\u0011\u0001\"C\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u000b\u0017\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\f\u000e\u0003\u0015I!\u0001G\u0003\u0003%A\u000b'/];fi\u001aKG\u000e^3s'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u0013M\u0004\u0018M]6D_:4W#\u0001\u0010\u0011\u0005}\u0001S\"A\u0007\n\u0005\u0005j!!C*qCJ\\7i\u001c8g\u0003Q\u0019\u0007.Z2l\r&dG/\u001a:Qe\u0016$\u0017nY1uKR1AE\u000b IGR\u0004\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012A!\u00168ji\")1f\u0001a\u0001Y\u0005\u0011AM\u001a\t\u0003[mr!AL\u001d\u000f\u0005=BdB\u0001\u00198\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025'\u00051AH]8pizJ\u0011AE\u0005\u0003!EI!AD\b\n\u00051i\u0011B\u0001\u001e\f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001\u001e\f\u0011\u0015y4\u00011\u0001A\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)5\"\u0001\u0005dCR\fG._:u\u0013\t9%IA\u0005Qe\u0016$\u0017nY1uK\")\u0011j\u0001a\u0001\u0015\u0006Ya-\u001b7uKJ\u001cE.Y:ta\tYU\u000bE\u0002M!Ns!!\u0014(\u0011\u0005I2\u0013BA('\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0006\u00072\f7o\u001d\u0006\u0003\u001f\u001a\u0002\"\u0001V+\r\u0001\u0011Ia\u000bSA\u0001\u0002\u0003\u0015\ta\u0016\u0002\u0006?\u0012\u0012t\u0007M\t\u00031n\u0003\"!J-\n\u0005i3#a\u0002(pi\"Lgn\u001a\t\u00039\u0006l\u0011!\u0018\u0006\u0003\u007fyS!a\u00181\u0002\u000f\u0019LG\u000e^3se)\u0011aaD\u0005\u0003Ev\u0013qBR5mi\u0016\u0014\bK]3eS\u000e\fG/\u001a\u0005\u0006I\u000e\u0001\r!Z\u0001\bG\",7m[3s!\u0015)c\r\f5%\u0013\t9gEA\u0005Gk:\u001cG/[8oeA\u0019\u0011.\u001c9\u000f\u0005)dgB\u0001\u001al\u0013\u00059\u0013B\u0001\u001e'\u0013\tqwNA\u0002TKFT!A\u000f\u0014\u0011\u0005E\u0014X\"A\u0006\n\u0005M\\!a\u0001*po\")Qo\u0001a\u0001Q\u0006AQ\r\u001f9fGR,G\r\u000b\u0002\u0001oB\u0011\u0001p_\u0007\u0002s*\u0011!0D\u0001\u0005i\u0006<7/\u0003\u0002}s\nyQ\t\u001f;f]\u0012,GmU)M)\u0016\u001cH\u000f")
public class ParquetV1FilterSuite
extends ParquetFilterSuite {
    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this).set(SQLConf$.MODULE$.USE_V1_SOURCE_LIST(), (Object)"parquet");
    }

    @Override
    public void checkFilterPredicate(Dataset<Row> df, Predicate predicate, Class<? extends FilterPredicate> filterClass, Function2<Dataset<Row>, Seq<Row>, BoxedUnit> checker, Seq<Row> expected) {
        Seq output = (Seq)((TreeNode)predicate).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    return (B1)attribute;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof Attribute;
            }
        }).distinct();
        new .colon.colon((Object)new Tuple2((Object)"parquet", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String pushdownDsList = (String)tuple2._1();
                boolean nestedPredicatePushdown = tuple2._2$mcZ$sp();
                return this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_DATE_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_DECIMAL_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_STRING_STARTSWITH_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OPTIMIZER_EXCLUDED_RULES().key()), (Object)InferFiltersFromConstraints$.MODULE$.ruleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST().key()), (Object)pushdownDsList)}), (Function0 & Serializable)() -> {
                    Dataset query = df.select((Seq)output.map((Function1 & Serializable)e -> Column$.MODULE$.apply((Expression)e))).where(Column$.MODULE$.apply((Expression)predicate));
                    Option nestedOrAttributes = ((TreeNode)predicate).collectFirst((PartialFunction)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 instanceof GetStructField) {
                                GetStructField getStructField = (GetStructField)A1;
                                return (B1)getStructField;
                            }
                            if (A1 instanceof Attribute) {
                                Attribute attribute = (Attribute)A1;
                                return (B1)attribute;
                            }
                            return (B1)function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Expression x2) {
                            Expression expression = x2;
                            if (expression instanceof GetStructField) {
                                return true;
                            }
                            return expression instanceof Attribute;
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(nestedOrAttributes.isDefined(), "nestedOrAttributes.isDefined", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"No GetStructField nor Attribute is detected.", Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2249));
                    Seq parsed = CatalogV2Implicits$.MODULE$.parseColumnPath((String)PushableColumnAndNestedColumn$.MODULE$.unapply((Expression)nestedOrAttributes.get()).get());
                    boolean containsNestedColumnOrDot = parsed.length() > 1 || ((String)parsed.apply(0)).contains(".");
                    ObjectRef maybeRelation = ObjectRef.create((Object)None$.MODULE$);
                    Option maybeAnalyzedPredicate = ((IterableOnceOps)query.queryExecution().optimizedPlan().collect((PartialFunction)new Serializable(null, maybeRelation){
                        private static final long serialVersionUID = 0L;
                        private final ObjectRef maybeRelation$1;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                            Option option;
                            A1 A1 = x3;
                            if (A1 != null && !(option = PhysicalOperation$.MODULE$.unapply(A1)).isEmpty()) {
                                LogicalRelation logicalRelation;
                                BaseRelation relation;
                                Seq filters = (Seq)((Tuple3)option.get())._2();
                                LogicalPlan logicalPlan = (LogicalPlan)((Tuple3)option.get())._3();
                                if (logicalPlan instanceof LogicalRelation && (relation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation) {
                                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)relation;
                                    this.maybeRelation$1.elem = new Some((Object)hadoopFsRelation);
                                    return (B1)filters;
                                }
                            }
                            return (B1)function1.apply(x3);
                        }

                        public final boolean isDefinedAt(LogicalPlan x3) {
                            LogicalRelation logicalRelation;
                            BaseRelation relation;
                            LogicalPlan logicalPlan;
                            Option option;
                            LogicalPlan logicalPlan2 = x3;
                            return logicalPlan2 != null && !(option = PhysicalOperation$.MODULE$.unapply(logicalPlan2)).isEmpty() && (logicalPlan = (LogicalPlan)((Tuple3)option.get())._3()) instanceof LogicalRelation && (relation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation;
                        }
                        {
                            this.maybeRelation$1 = maybeRelation$1;
                        }
                    }).flatten(Predef$.MODULE$.$conforms())).reduceLeftOption((Function2 & Serializable)(x$14, x$15) -> package.expressions$.MODULE$.DslExpression(x$14).$amp$amp(x$15));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(maybeAnalyzedPredicate.isDefined(), "maybeAnalyzedPredicate.isDefined", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No filter is analyzed from the given query", Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2263));
                    Tuple3 tuple3 = DataSourceStrategy$.MODULE$.selectFilters((BaseRelation)((Option)maybeRelation.elem).get(), Option$.MODULE$.option2Iterable(maybeAnalyzedPredicate).toSeq());
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Seq selectedFilters = (Seq)tuple3._2();
                    Seq selectedFilters2 = selectedFilters;
                    if (nestedPredicatePushdown || !containsNestedColumnOrDot) {
                        Seq $org_scalatest_assert_macro_left = selectedFilters2;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"No filter is pushed down", Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2270));
                        MessageType schema = new SparkToParquetSchemaConverter(this.conf()).convert(df.schema());
                        ParquetFilters parquetFilters = this.createParquetFilters(schema, this.createParquetFilters$default$2(), this.createParquetFilters$default$3());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(parquetFilters.convertibleFilters(selectedFilters2));
                        Seq $org_scalatest_assert_macro_right = selectedFilters2;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2274));
                        Seq pushedParquetFilters = (Seq)selectedFilters2.map((Function1 & Serializable)pred -> {
                            Option maybeFilter = parquetFilters.createFilter(pred);
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeFilter.isDefined(), "maybeFilter.isDefined", Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Couldn't generate filter predicate for " + pred), Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2277));
                            return (FilterPredicate)maybeFilter.get();
                        });
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(pushedParquetFilters.exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ParquetV1FilterSuite.$anonfun$checkFilterPredicate$8(this, filterClass, x$16))), "pushedParquetFilters.exists(((x$16: org.apache.parquet.filter2.predicate.FilterPredicate) => ParquetV1FilterSuite.this.convertToEqualizer[Class[T]](x$16.getClass()).===(filterClass)(scalactic.this.Equality.default[Class[T]])))", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)(((IterableOnceOps)pushedParquetFilters.map((Function1 & Serializable)x$17 -> x$17.getClass())).toList() + " did not contain " + filterClass + "."), Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2281));
                        return checker.apply(this.stripSparkFilter((Dataset<Row>)query), (Object)expected);
                    }
                    Seq $org_scalatest_assert_macro_left = selectedFilters2;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"There is filter pushed down", Prettifier$.MODULE$.default(), new Position("ParquetFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2286));
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkFilterPredicate$8(ParquetV1FilterSuite $this, Class filterClass$1, FilterPredicate x$16) {
        return $this.convertToEqualizer(x$16.getClass()).$eq$eq$eq((Object)filterClass$1, Equality$.MODULE$.default());
    }
}

