/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaByteArrayReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\n\u0015\u0001\rBQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004E\u0001\u0001\u0006Ia\r\u0005\b\u000b\u0002\u0011\r\u0011\"\u00013\u0011\u00191\u0005\u0001)A\u0005g!Iq\t\u0001a\u0001\u0002\u0004%\t\u0001\u0013\u0005\n'\u0002\u0001\r\u00111A\u0005\u0002QC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015B%\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003a\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0001b\u0011%\u0019\u0007\u00011A\u0001B\u0003&Q\fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005K\"IA\u000e\u0001a\u0001\u0002\u0004%I!\u001c\u0005\n_\u0002\u0001\r\u0011!Q!\n\u0019DQ\u0001\u001d\u0001\u0005REDQA\u001d\u0001\u0005\nMDQ\u0001\u001f\u0001\u0005\neDQ! \u0001\u0005\ny\u0014!\u0005U1scV,G\u000fR3mi\u0006\u0014\u0015\u0010^3BeJ\f\u00170\u00128d_\u0012LgnZ*vSR,'BA\u000b\u0017\u0003\u001d\u0001\u0018M]9vKRT!a\u0006\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00033i\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\u0003\u0006\u0005\u0002&M5\tA#\u0003\u0002()\tA\u0002+\u0019:rk\u0016$8i\\7qCRL'-\u001b7jif$Vm\u001d;\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-R\u0012\u0001\u0002;fgRL!!\f\u0016\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\n\u0001\u0002\rY\fG.^3t+\u0005\u0019\u0004c\u0001\u001b8s5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0003BeJ\f\u0017\u0010\u0005\u0002;\u0003:\u00111h\u0010\t\u0003yUj\u0011!\u0010\u0006\u0003}\t\na\u0001\u0010:p_Rt\u0014B\u0001!6\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001+\u0014a\u0002<bYV,7\u000fI\u0001\u000be\u0006tGM^1mk\u0016\u001c\u0018a\u0003:b]\u00124\u0018\r\\;fg\u0002\naa\u001e:ji\u0016\u0014X#A%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015\u0001\u00043fYR\f7\u000f\u001e:j]\u001e\u001c(BA\u0019O\u0015\ty\u0005+\u0001\u0004d_2,XN\u001c\u0006\u0003+yI!AU&\u0003)\u0011+G\u000e^1CsR,\u0017I\u001d:bs^\u0013\u0018\u000e^3s\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0003+b\u0003\"\u0001\u000e,\n\u0005]+$\u0001B+oSRDq!W\u0004\u0002\u0002\u0003\u0007\u0011*A\u0002yIE\nqa\u001e:ji\u0016\u0014\b%\u0001\u0004sK\u0006$WM]\u000b\u0002;B\u0011QEX\u0005\u0003?R\u0011aDV3di>\u0014\u0018N_3e\t\u0016dG/\u0019\"zi\u0016\f%O]1z%\u0016\fG-\u001a:\u0002\u0015I,\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0002VE\"9\u0011LCA\u0001\u0002\u0004i\u0016a\u0002:fC\u0012,'\u000fI\u0001\u0015oJLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\r\u0002\u0015Y,7\r^8sSj,G-\u0003\u0002lQ\n!rK]5uC\ndWmQ8mk6tg+Z2u_J\f\u0001d\u001e:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014x\fJ3r)\t)f\u000eC\u0004Z\u001b\u0005\u0005\t\u0019\u00014\u0002+]\u0014\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8sA\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003U\u000bq\"Y:tKJ$(+Z1e/JLG/\u001a\u000b\u0005+R,h\u000fC\u0003H!\u0001\u0007\u0011\nC\u0003\\!\u0001\u0007Q\fC\u0003x!\u0001\u00071'\u0001\u0003wC2\u001c\u0018aF1tg\u0016\u0014HOU3bI^\u0013\u0018\u000e^3XSRD7k[5q)\u0011)&p\u001f?\t\u000b\u001d\u000b\u0002\u0019A%\t\u000bm\u000b\u0002\u0019A/\t\u000b]\f\u0002\u0019A\u001a\u00021\u0005\u001c8/\u001a:u%\u0016\fGm\u0016:ji\u0016<\u0016\u000e\u001e5TW&\u0004h\n\u0006\u0004V\u007f\u0006\u0005\u00111\u0001\u0005\u0006\u000fJ\u0001\r!\u0013\u0005\u00067J\u0001\r!\u0018\u0005\u0006oJ\u0001\ra\r")
public class ParquetDeltaByteArrayEncodingSuite
extends ParquetCompatibilityTest
implements SharedSparkSession {
    private final String[] values;
    private final String[] randvalues;
    private DeltaByteArrayWriter writer;
    private VectorizedDeltaByteArrayReader reader;
    private WritableColumnVector writableColumnVector;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public String[] values() {
        return this.values;
    }

    public String[] randvalues() {
        return this.randvalues;
    }

    public DeltaByteArrayWriter writer() {
        return this.writer;
    }

    public void writer_$eq(DeltaByteArrayWriter x$1) {
        this.writer = x$1;
    }

    public VectorizedDeltaByteArrayReader reader() {
        return this.reader;
    }

    public void reader_$eq(VectorizedDeltaByteArrayReader x$1) {
        this.reader = x$1;
    }

    private WritableColumnVector writableColumnVector() {
        return this.writableColumnVector;
    }

    private void writableColumnVector_$eq(WritableColumnVector x$1) {
        this.writableColumnVector = x$1;
    }

    @Override
    public void beforeEach() {
        this.writer_$eq(new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator()));
        this.reader_$eq(new VectorizedDeltaByteArrayReader());
        SharedSparkSession.beforeAll$(this);
    }

    private void assertReadWrite(DeltaByteArrayWriter writer, VectorizedDeltaByteArrayReader reader, String[] vals) {
        Utils.writeData((ValuesWriter)writer, (String[])vals);
        int length = vals.length;
        ByteBufferInputStream is = writer.getBytes().toInputStream();
        this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)StringType$.MODULE$));
        reader.initFromPage(length, is);
        reader.readBinary(length, this.writableColumnVector(), 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable)i -> ParquetDeltaByteArrayEncodingSuite.$anonfun$assertReadWrite$1(this, vals, BoxesRunTime.unboxToInt((Object)i)));
    }

    private void assertReadWriteWithSkip(DeltaByteArrayWriter writer, VectorizedDeltaByteArrayReader reader, String[] vals) {
        Utils.writeData((ValuesWriter)writer, (String[])vals);
        int length = vals.length;
        ByteBufferInputStream is = writer.getBytes().toInputStream();
        this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)StringType$.MODULE$));
        reader.initFromPage(length, is);
        for (int i = 0; i < vals.length; i += 2) {
            reader.readBinary(1, this.writableColumnVector(), i);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapByteArray(vals[i].getBytes()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.writableColumnVector().getBinary(i))), "scala.Predef.wrapByteArray(vals.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            reader.skipBinary(1);
        }
    }

    private void assertReadWriteWithSkipN(DeltaByteArrayWriter writer, VectorizedDeltaByteArrayReader reader, String[] vals) {
        Utils.writeData((ValuesWriter)writer, (String[])vals);
        int length = vals.length;
        ByteBufferInputStream is = writer.getBytes().toInputStream();
        this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)StringType$.MODULE$));
        reader.initFromPage(length, is);
        int skipCount = 0;
        for (int i = 0; i < vals.length; i += skipCount + 1) {
            skipCount = (vals.length - i) / 2;
            reader.readBinary(1, this.writableColumnVector(), i);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapByteArray(vals[i].getBytes()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.writableColumnVector().getBinary(i))), "scala.Predef.wrapByteArray(vals.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            reader.skipBinary(skipCount);
        }
    }

    public static final /* synthetic */ Assertion $anonfun$assertReadWrite$1(ParquetDeltaByteArrayEncodingSuite $this, String[] vals$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapByteArray(vals$1[i].getBytes()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray($this.writableColumnVector().getBinary(i))), "scala.Predef.wrapByteArray(vals.apply(i).getBytes()).sameElements[Byte](scala.Predef.wrapByteArray(ParquetDeltaByteArrayEncodingSuite.this.writableColumnVector.getBinary(i)))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }

    public ParquetDeltaByteArrayEncodingSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.values = (String[])((Object[])new String[]{"parquet-mr", "parquet", "parquet-format"});
        this.randvalues = Utils.getRandomStringSamples((int)10000, (int)32);
        this.test("test Serialization", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.assertReadWrite(this.writer(), this.reader(), this.values()), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("random strings", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.assertReadWrite(this.writer(), this.reader(), this.randvalues()), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("random strings with skip", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.assertReadWriteWithSkip(this.writer(), this.reader(), this.randvalues()), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("random strings with skipN", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.assertReadWriteWithSkipN(this.writer(), this.reader(), this.randvalues()), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("test lengths", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            VectorizedDeltaBinaryPackedReader reader = new VectorizedDeltaBinaryPackedReader();
            Utils.writeData((ValuesWriter)this.writer(), (String[])this.values());
            ByteBufferInputStream data = this.writer().getBytes().toInputStream();
            int length = this.values().length;
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)IntegerType$.MODULE$));
            reader.initFromPage(length, data);
            reader.readIntegers(length, this.writableColumnVector(), 0);
            int $org_scalatest_assert_macro_left = 0;
            int $org_scalatest_assert_macro_right = this.writableColumnVector().getInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            int $org_scalatest_assert_macro_left2 = 7;
            int $org_scalatest_assert_macro_right2 = this.writableColumnVector().getInt(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            int $org_scalatest_assert_macro_left3 = 7;
            int $org_scalatest_assert_macro_right3 = this.writableColumnVector().getInt(2);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            reader = new VectorizedDeltaBinaryPackedReader();
            this.writableColumnVector_$eq((WritableColumnVector)new OnHeapColumnVector(length, (DataType)IntegerType$.MODULE$));
            reader.initFromPage(length, data);
            reader.readIntegers(length, this.writableColumnVector(), 0);
            int $org_scalatest_assert_macro_left4 = 10;
            int $org_scalatest_assert_macro_right4 = this.writableColumnVector().getInt(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            int $org_scalatest_assert_macro_left5 = 0;
            int $org_scalatest_assert_macro_right5 = this.writableColumnVector().getInt(1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            int $org_scalatest_assert_macro_left6 = 7;
            int $org_scalatest_assert_macro_right6 = this.writableColumnVector().getInt(2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("ParquetDeltaByteArrayEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        Statics.releaseFence();
    }
}

