/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.binaryfile;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.binaryfile.BinaryFileFormat;
import org.apache.spark.sql.execution.datasources.binaryfile.BinaryFileFormat$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\n\u0015\u0001\rBQA\f\u0001\u0005\u0002=B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011B\u001a\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0005\"C%\u0001\u0001\u0004\u0005\t\u0015)\u00035\u0011%Q\u0005\u00011AA\u0002\u0013%1\nC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0014\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\naC\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011B/\t\u0013}\u0003\u0001\u0019!A!B\u0013I\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0003b\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005i\u0001\u0001\u0007\t\u0011)Q\u0005E\")\u0011\u000e\u0001C!U\")1\u000e\u0001C\u0001Y\")q\u000e\u0001C\u0001a\")\u0001\u0010\u0001C\u0001s\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\"!\u0006\"j]\u0006\u0014\u0018PR5mK\u001a{'/\\1u'VLG/\u001a\u0006\u0003+Y\t!BY5oCJLh-\u001b7f\u0015\t9\u0002$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\r\u001b\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I!\u0002\"!\n\u0014\u000e\u0003iI!a\n\u000e\u0003\u0013E+XM]=UKN$\bCA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0011!Xm\u001d;\n\u00055R#AE*iCJ,Gm\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u000b\u0002\u000fQ,7\u000f\u001e#jeV\tA\u0007\u0005\u00026}9\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\t\na\u0001\u0010:p_Rt$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\u001e\u0002\u0017Q,7\u000f\u001e#je~#S-\u001d\u000b\u0003\u0007\u001e\u0003\"\u0001R#\u000e\u0003iJ!A\u0012\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0011\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\ti\u0016\u001cH\u000fR5sA\u0005Iam\u001d+fgR$\u0015N]\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0003MNT!!\u0015\u0010\u0002\r!\fGm\\8q\u0013\t\u0019fJ\u0001\u0003QCRD\u0017!\u00044t)\u0016\u001cH\u000fR5s?\u0012*\u0017\u000f\u0006\u0002D-\"9\u0001JBA\u0001\u0002\u0004a\u0015A\u00034t)\u0016\u001cH\u000fR5sAU\t\u0011\f\u0005\u0002N5&\u00111L\u0014\u0002\u000b\r&dWmU=ti\u0016l\u0017A\u00024t?\u0012*\u0017\u000f\u0006\u0002D=\"9\u0001*CA\u0001\u0002\u0004I\u0016a\u00014tA\u0005Ya-\u001b7fcM#\u0018\r^;t+\u0005\u0011\u0007CA'd\u0013\t!gJ\u0001\u0006GS2,7\u000b^1ukN\fqBZ5mKF\u001aF/\u0019;vg~#S-\u001d\u000b\u0003\u0007\u001eDq\u0001\u0013\u0007\u0002\u0002\u0003\u0007!-\u0001\u0007gS2,\u0017g\u0015;biV\u001c\b%A\u0005cK\u001a|'/Z!mYR\t1)\u0001\ruKN$()\u001b8bef4\u0015\u000e\\3ECR\f7k\\;sG\u0016$\"aQ7\t\u000b9|\u0001\u0019\u0001\u001b\u0002\u001dA\fG\u000f[$m_\n4\u0015\u000e\u001c;fe\u0006qQn\\2l\r&dWm\u0015;biV\u001cHc\u00012rm\")!\u000f\u0005a\u0001g\u00061A.\u001a8hi\"\u0004\"\u0001\u0012;\n\u0005UT$\u0001\u0002'p]\u001eDQa\u001e\tA\u0002M\f\u0001#\\8eS\u001aL7-\u0019;j_:$\u0016.\\3\u00021Q,7\u000f^\"sK\u0006$XMR5mi\u0016\u0014h)\u001e8di&|g\u000e\u0006\u0003Du\u0006]\u0001\"B>\u0012\u0001\u0004a\u0018a\u00024jYR,'o\u001d\t\u0006{\u0006\u0015\u00111\u0002\b\u0004}\u0006\u0005aBA\u001c\u0000\u0013\u0005Y\u0014bAA\u0002u\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0004\u0003\u0013\u00111aU3r\u0015\r\t\u0019A\u000f\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u000e\u0002\u000fM|WO]2fg&!\u0011QCA\b\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011\u0011D\tA\u0002\u0005m\u0011!\u0003;fgR\u001c\u0015m]3t!\u0015i\u0018QAA\u000f!\u0019!\u0015q\u00042\u0002$%\u0019\u0011\u0011\u0005\u001e\u0003\rQ+\b\u000f\\33!\r!\u0015QE\u0005\u0004\u0003OQ$a\u0002\"p_2,\u0017M\\\u0001\u000fe\u0016\fGMQ5oCJLh)\u001b7f)\u0019\ti#a\r\u0002HA\u0019Q%a\f\n\u0007\u0005E\"DA\u0002S_^Dq!!\u000e\u0013\u0001\u0004\t9$\u0001\u0003gS2,\u0007\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0003S>T!!!\u0011\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\nYD\u0001\u0003GS2,\u0007bBA%%\u0001\u0007\u00111J\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)5\u0005)A/\u001f9fg&!\u0011QKA(\u0005)\u0019FO];diRK\b/\u001a")
public class BinaryFileFormatSuite
extends QueryTest
implements SharedSparkSession {
    private String testDir;
    private Path fsTestDir;
    private FileSystem fs;
    private FileStatus file1Status;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, scala.collection.immutable.Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, scala.collection.immutable.Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<scala.collection.immutable.Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ Object org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(scala.collection.immutable.Seq pairs, Function0 f) {
        return SQLConfHelper.withSQLConf$((SQLConfHelper)this, (scala.collection.immutable.Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public <T> T withSQLConf(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(scala.collection.immutable.Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(scala.collection.immutable.Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(scala.collection.immutable.Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(scala.collection.immutable.Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(scala.collection.immutable.Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(scala.collection.immutable.Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(scala.collection.immutable.Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(scala.collection.immutable.Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$(this, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private String testDir() {
        return this.testDir;
    }

    private void testDir_$eq(String x$1) {
        this.testDir = x$1;
    }

    private Path fsTestDir() {
        return this.fsTestDir;
    }

    private void fsTestDir_$eq(Path x$1) {
        this.fsTestDir = x$1;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    private FileStatus file1Status() {
        return this.file1Status;
    }

    private void file1Status_$eq(FileStatus x$1) {
        this.file1Status = x$1;
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        this.testDir_$eq(Utils$.MODULE$.createTempDir().getAbsolutePath());
        this.fsTestDir_$eq(new Path(this.testDir()));
        this.fs_$eq(this.fsTestDir().getFileSystem(this.sparkContext().hadoopConfiguration()));
        File year2014Dir = new File(this.testDir(), "year=2014");
        year2014Dir.mkdir();
        File year2015Dir = new File(this.testDir(), "year=2015");
        year2015Dir.mkdir();
        File file1 = new File(year2014Dir, "data.txt");
        Files.write(file1.toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"2014-test", (List)Nil$.MODULE$)).asJava(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.file1Status_$eq(this.fs().getFileStatus(new Path(file1.getPath())));
        File file2 = new File(year2014Dir, "data2.bin");
        Files.write(file2.toPath(), "2014-test-bin".getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        File file3 = new File(year2015Dir, "bool.csv");
        Files.write(file3.toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"bool", (List)new .colon.colon((Object)"True", (List)new .colon.colon((Object)"False", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$))))).asJava(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        File file4 = new File(year2015Dir, "data.bin");
        Files.write(file4.toPath(), "2015-test".getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public void testBinaryFileDataSource(String pathGlobFilter) {
        DataFrameReader dfReader = this.spark().read().format(BinaryFileFormat$.MODULE$.BINARY_FILE());
        Object object = pathGlobFilter != null ? dfReader.option("pathGlobFilter", pathGlobFilter) : BoxedUnit.UNIT;
        Dataset resultDF = dfReader.load(this.testDir()).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(BinaryFileFormat$.MODULE$.PATH()), functions$.MODULE$.col(BinaryFileFormat$.MODULE$.MODIFICATION_TIME()), functions$.MODULE$.col(BinaryFileFormat$.MODULE$.LENGTH()), functions$.MODULE$.col(BinaryFileFormat$.MODULE$.CONTENT()), functions$.MODULE$.col("year")}));
        HashSet expectedRowSet = new HashSet();
        GlobFilter globFilter = pathGlobFilter == null ? null : new GlobFilter(pathGlobFilter);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.fs().listStatus(this.fsTestDir())), (Function1 & Serializable)partitionDirStatus -> {
            BinaryFileFormatSuite.$anonfun$testBinaryFileDataSource$1(this, globFilter, expectedRowSet, partitionDirStatus);
            return BoxedUnit.UNIT;
        });
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> resultDF, (scala.collection.immutable.Seq<Row>)expectedRowSet.toSeq());
    }

    public FileStatus mockFileStatus(long length, long modificationTime) {
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)status.getLen())).thenReturn((Object)BoxesRunTime.boxToLong((long)length));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)status.getModificationTime())).thenReturn((Object)BoxesRunTime.boxToLong((long)modificationTime));
        Mockito.when((Object)status.toString()).thenReturn((Object)("FileStatus(" + BinaryFileFormat$.MODULE$.LENGTH() + "=" + length + ", " + BinaryFileFormat$.MODULE$.MODIFICATION_TIME() + "=" + modificationTime + ")"));
        return status;
    }

    public void testCreateFilterFunction(scala.collection.immutable.Seq<Filter> filters, scala.collection.immutable.Seq<Tuple2<FileStatus, Object>> testCases) {
        scala.collection.immutable.Seq funcs = (scala.collection.immutable.Seq)filters.flatMap((Function1 & Serializable)filter -> BinaryFileFormat$.MODULE$.createFilterFunction(filter));
        testCases.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                FileStatus status = (FileStatus)tuple2._1();
                boolean expected = tuple2._2$mcZ$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)funcs.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BinaryFileFormatSuite.$anonfun$testCreateFilterFunction$3(status, f)))));
                boolean $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)(filters + " applied to " + status + " should be " + expected + "."), Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Row readBinaryFile(File file, StructType requiredSchema) {
        BinaryFileFormat format = new BinaryFileFormat();
        Function1 reader = format.buildReaderWithPartitionValues(this.spark(), BinaryFileFormat$.MODULE$.schema(), StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), requiredSchema, (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), Predef$.MODULE$.Map().empty(), this.spark().sessionState().newHadoopConf());
        PartitionedFile partitionedFile = (PartitionedFile)Mockito.mock(PartitionedFile.class);
        Mockito.when((Object)partitionedFile.toPath()).thenReturn((Object)new Path(file.toURI()));
        ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(requiredSchema);
        scala.collection.immutable.Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$2);
        return (Row)encoder.createDeserializer().apply((InternalRow)((Iterator)reader.apply((Object)partitionedFile)).next());
    }

    private final void testImplicits$lzycompute$1() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        BinaryFileFormatSuite binaryFileFormatSuite = this;
        synchronized (binaryFileFormatSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testBinaryFileDataSource$1(BinaryFileFormatSuite $this, GlobFilter globFilter$1, HashSet expectedRowSet$1, FileStatus partitionDirStatus) {
        Path dirPath = partitionDirStatus.getPath();
        String partitionName = dirPath.getName().split("=")[1];
        int year = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partitionName));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])$this.fs().listStatus(dirPath)), (Function1 & Serializable)fileStatus -> {
            if (globFilter$1 == null || globFilter$1.accept(fileStatus.getPath())) {
                byte[] content;
                byte[] byArray;
                String fpath = fileStatus.getPath().toString();
                long flen = fileStatus.getLen();
                Timestamp modificationTime = new Timestamp(fileStatus.getModificationTime());
                FSDataInputStream stream = $this.fs().open(fileStatus.getPath());
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                byte[] fcontent = content = byArray;
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fpath, modificationTime, BoxesRunTime.boxToLong((long)flen), fcontent, BoxesRunTime.boxToInteger((int)year)}));
                return BoxesRunTime.boxToBoolean((boolean)expectedRowSet$1.add((Object)row));
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$4(BinaryFileFormatSuite $this, Dataset df$1, File tmpDir) {
        UnsupportedOperationException thrown = (UnsupportedOperationException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> df$1.write().format(BinaryFileFormat$.MODULE$.BINARY_FILE()).save(tmpDir + "/test_save"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = "Write is not supported for binary file data source";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
    }

    public static final /* synthetic */ boolean $anonfun$testCreateFilterFunction$3(FileStatus status$1, Function1 f) {
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)status$1));
    }

    private final void testBuildReader$1(FileStatus fileStatus, scala.collection.immutable.Seq filters, boolean expected) {
        BinaryFileFormat format = new BinaryFileFormat();
        Function1 reader = format.buildReaderWithPartitionValues(this.spark(), BinaryFileFormat$.MODULE$.schema(), StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), BinaryFileFormat$.MODULE$.schema(), filters, Predef$.MODULE$.Map().empty(), this.spark().sessionState().newHadoopConf());
        PartitionedFile partitionedFile = (PartitionedFile)Mockito.mock(PartitionedFile.class);
        Mockito.when((Object)partitionedFile.toPath()).thenReturn((Object)fileStatus.getPath());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((IterableOnceOps)reader.apply((Object)partitionedFile)).nonEmpty()));
        boolean $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Filters " + filters + " applied to " + fileStatus + " should be " + expected + "."), Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
    }

    public static final /* synthetic */ void $anonfun$new$9(BinaryFileFormatSuite $this, File file) {
        byte[] content = "123".getBytes();
        Files.write(file.toPath(), content, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Row actual = $this.readBinaryFile(file, StructType$.MODULE$.apply((scala.collection.immutable.Seq)BinaryFileFormat$.MODULE$.schema().takeRight(3)));
        Row expected = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(file.lastModified()), BoxesRunTime.boxToInteger((int)content.length), content}));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(actual);
        Row $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
    }

    public static final /* synthetic */ void $anonfun$new$11(BinaryFileFormatSuite $this, File file) {
        byte[] content = "abc".getBytes();
        Files.write(file.toPath(), content, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        file.setReadable(false);
        $this.intercept((Function0 & Serializable)() -> {
            StructField structField = BinaryFileFormat$.MODULE$.schema().apply(BinaryFileFormat$.MODULE$.CONTENT());
            return $this.readBinaryFile(file, StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField)));
        }, ClassTag$.MODULE$.apply(IOException.class), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        StructField structField = BinaryFileFormat$.MODULE$.schema().apply(BinaryFileFormat$.MODULE$.LENGTH());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.readBinaryFile(file, StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField))));
        Row $org_scalatest_assert_macro_right = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)content.length)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Get length should not read content.", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)$this.spark().read().format(BinaryFileFormat$.MODULE$.BINARY_FILE()).load(file.getPath()).count()));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Count should not read content.", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
    }

    private final Dataset readContent$1(String path$1) {
        return this.spark().read().format(BinaryFileFormat$.MODULE$.BINARY_FILE()).load(path$1).select(BinaryFileFormat$.MODULE$.CONTENT(), (scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$16(BinaryFileFormatSuite $this, scala.collection.immutable.Seq expected$1, String path$1) {
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.readContent$1(path$1), (scala.collection.immutable.Seq<Row>)expected$1);
    }

    public static final /* synthetic */ void $anonfun$new$18(BinaryFileFormatSuite $this, byte[] content$1, scala.collection.immutable.Seq expected$1, String path$1) {
        $this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH().key()), (Object)Integer.toString(content$1.length - 1))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.readContent$1(path$1), (scala.collection.immutable.Seq<Row>)expected$1));
    }

    public static final /* synthetic */ void $anonfun$new$14(BinaryFileFormatSuite $this, File file) {
        String path = file.getPath();
        byte[] content = "123".getBytes();
        Files.write(file.toPath(), content, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        .colon.colon expected = new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{content})), (List)Nil$.MODULE$);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.readContent$1(path), (scala.collection.immutable.Seq<Row>)expected);
        $this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH().key()), (Object)Integer.toString(content.length))}), (Function0)((JFunction0.mcV.sp & Serializable)() -> BinaryFileFormatSuite.$anonfun$new$16($this, (scala.collection.immutable.Seq)expected, path)));
        file.setReadable(false);
        SparkException caught = (SparkException)((Object)$this.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> BinaryFileFormatSuite.$anonfun$new$18($this, content, (scala.collection.immutable.Seq)expected, path)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364)));
        String $org_scalatest_assert_macro_left = caught.getMessage();
        String $org_scalatest_assert_macro_right = "exceeds the max length allowed";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }

    public static final /* synthetic */ void $anonfun$new$22(BinaryFileFormatSuite $this, File dir) {
        Some some;
        File file = new File(dir, "test space.txt");
        byte[] content = "123".getBytes();
        Files.write(file.toPath(), content, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Dataset df = $this.spark().read().format(BinaryFileFormat$.MODULE$.BINARY_FILE()).load(dir.getPath());
        Row row = (Row)df.select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(BinaryFileFormat$.MODULE$.PATH()), functions$.MODULE$.col(BinaryFileFormat$.MODULE$.CONTENT())})).first();
        if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
            Object p = ((SeqOps)some.get()).apply(0);
            Object c = ((SeqOps)some.get()).apply(1);
            if (p instanceof String) {
                String string = (String)p;
                if (c instanceof byte[]) {
                    byte[] byArray = (byte[])c;
                    String $org_scalatest_assert_macro_left = string;
                    String $org_scalatest_assert_macro_right = file.getAbsolutePath();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should support space in file name", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(byArray);
                    byte[] $org_scalatest_assert_macro_right2 = content;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should read file with space in file name", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
                    return;
                }
            }
        }
        throw new MatchError((Object)row);
    }

    public BinaryFileFormatSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("BinaryFileFormat methods", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BinaryFileFormat format = new BinaryFileFormat();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(format.shortName());
            String $org_scalatest_assert_macro_right = "binaryFile";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)format.isSplitable(this.spark(), Predef$.MODULE$.Map().empty(), new Path("any"))));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(format.inferSchema(this.spark(), Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
            Some $org_scalatest_assert_macro_right3 = new Some((Object)BinaryFileFormat$.MODULE$.schema());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BinaryFileFormat$.MODULE$.schema());
            StructType $org_scalatest_assert_macro_right4 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("path", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("modificationTime", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("length", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("content", (DataType)BinaryType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("binary file data source test", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.testBinaryFileDataSource(null);
            this.testBinaryFileDataSource("*.*");
            this.testBinaryFileDataSource("*.bin");
            this.testBinaryFileDataSource("*.txt");
            this.testBinaryFileDataSource("*.{txt,csv}");
            this.testBinaryFileDataSource("*.json");
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("binary file data source do not support write operation", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = this.spark().read().format(BinaryFileFormat$.MODULE$.BINARY_FILE()).load(this.testDir());
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)tmpDir -> {
                BinaryFileFormatSuite.$anonfun$new$4(this, df, tmpDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("createFilterFunction", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            FileStatus l1 = this.mockFileStatus(1L, 0L);
            FileStatus l2 = this.mockFileStatus(2L, 0L);
            FileStatus l3 = this.mockFileStatus(3L, 0L);
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new LessThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new LessThanOrEqual(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new GreaterThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new GreaterThanOrEqual(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new EqualTo(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Not((Filter)new EqualTo(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new And((Filter)new GreaterThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)1L)), (Filter)new LessThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)3L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Or((Filter)new LessThanOrEqual(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)1L)), (Filter)new GreaterThanOrEqual(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)3L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            FileStatus t1 = this.mockFileStatus(0L, 1L);
            FileStatus t2 = this.mockFileStatus(0L, 2L);
            FileStatus t3 = this.mockFileStatus(0L, 3L);
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new LessThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new LessThanOrEqual(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new GreaterThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new GreaterThanOrEqual(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new EqualTo(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Not((Filter)new EqualTo(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new And((Filter)new GreaterThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(1L)), (Filter)new LessThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(3L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Or((Filter)new LessThanOrEqual(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(1L)), (Filter)new GreaterThanOrEqual(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(3L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Not((Filter)new IsNull(BinaryFileFormat$.MODULE$.LENGTH())), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new And((Filter)new GreaterThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (Filter)new LessThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)))))));
            this.testCreateFilterFunction((scala.collection.immutable.Seq<Filter>)new .colon.colon((Object)new Not((Filter)new Or((Filter)new GreaterThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)2L)), (Filter)new LessThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(2L)))), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<Tuple2<FileStatus, Object>>)new .colon.colon((Object)new Tuple2((Object)l1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l2, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)l3, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t1, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)t3, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("buildReader", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.testBuildReader$1(this.file1Status(), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), true);
            this.testBuildReader$1(this.file1Status(), (scala.collection.immutable.Seq)new .colon.colon((Object)new LessThan(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)this.file1Status().getLen())), (List)Nil$.MODULE$), false);
            this.testBuildReader$1(this.file1Status(), (scala.collection.immutable.Seq)new .colon.colon((Object)new LessThan(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)new Timestamp(this.file1Status().getModificationTime())), (List)Nil$.MODULE$), false);
            this.testBuildReader$1(this.file1Status(), (scala.collection.immutable.Seq)new .colon.colon((Object)new EqualTo(BinaryFileFormat$.MODULE$.LENGTH(), (Object)BoxesRunTime.boxToLong((long)this.file1Status().getLen())), (List)new .colon.colon((Object)new EqualTo(BinaryFileFormat$.MODULE$.MODIFICATION_TIME(), (Object)BoxesRunTime.boxToLong((long)this.file1Status().getModificationTime())), (List)Nil$.MODULE$)), true);
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("column pruning", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
            BinaryFileFormatSuite.$anonfun$new$9(this, file);
            return BoxedUnit.UNIT;
        }), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("column pruning - non-readable file", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
            BinaryFileFormatSuite.$anonfun$new$11(this, file);
            return BoxedUnit.UNIT;
        }), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("fail fast and do not attempt to read if a file is too big", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().conf().get(SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH()));
            int $org_scalatest_assert_macro_right = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                BinaryFileFormatSuite.$anonfun$new$14(this, file);
                return BoxedUnit.UNIT;
            });
        }, new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("SPARK-28030: support chars in file names that require URL encoding", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            BinaryFileFormatSuite.$anonfun$new$22(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("BinaryFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        Statics.releaseFence();
    }
}

