/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.LocalSparkSession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t!#)Y:jG^\u0013\u0018\u000e^3K_\n\u001cF/\u0019;t)J\f7m[3s\u001b\u0016$(/[2Tk&$XM\u0003\u0002\u0005\u000b\u0005YA-\u0019;bg>,(oY3t\u0015\t1q!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\u000b\u0011\u0005I\u0019R\"A\u0005\n\u0005QI!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0017/5\tq!\u0003\u0002\u0019\u000f\t\tBj\\2bYN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0019\u0001")
public class BasicWriteJobStatsTrackerMetricSuite
extends SparkFunSuite
implements LocalSparkSession {
    private transient SparkSession spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void beforeAll() {
        LocalSparkSession.beforeAll$(this);
    }

    @Override
    public void afterEach() {
        LocalSparkSession.afterEach$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$2(SQLPlanMetric x$1) {
        String string = x$1.name();
        String string2 = "number of dynamic part";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public BasicWriteJobStatsTrackerMetricSuite() {
        LocalSparkSession.$init$(this);
        this.test("SPARK-32978: make sure the number of dynamic part metric is correct", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            try {
                Bool bool;
                String partitions = "50";
                this.spark_$eq(SparkSession$.MODULE$.builder().master("local[4]").getOrCreate());
                SQLAppStatusStore statusStore = this.spark().sharedState().statusStore();
                this.spark().sql("create table dynamic_partition(i bigint, part bigint) using parquet partitioned by (part)");
                int oldExecutionsSize = statusStore.executionsList().size();
                this.spark().sql("insert overwrite table dynamic_partition partition(part) select id, id % " + partitions + " as part from range(10000)");
                while (statusStore.executionsList().size() - oldExecutionsSize < 1 || ((SQLExecutionUIData)statusStore.executionsList().last()).metricValues() == null) {
                    Thread.sleep(100L);
                }
                long $org_scalatest_assert_macro_left = statusStore.executionsCount();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteJobStatsTrackerMetricSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                SQLExecutionUIData executionData = (SQLExecutionUIData)statusStore.executionsList().apply(1);
                Option accumulatorIdOpt = executionData.metrics().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicWriteJobStatsTrackerMetricSuite.$anonfun$new$2(x$1))).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.accumulatorId()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(accumulatorIdOpt.isDefined(), "accumulatorIdOpt.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteJobStatsTrackerMetricSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
                Option numPartsOpt = executionData.metricValues().get(accumulatorIdOpt.get());
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.simpleMacroBool(numPartsOpt.isDefined(), "numPartsOpt.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = (String)numPartsOpt.get();
                    String $org_scalatest_assert_macro_right2 = partitions;
                    String string = $org_scalatest_assert_macro_left3;
                    String string2 = $org_scalatest_assert_macro_right2;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteJobStatsTrackerMetricSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            }
            finally {
                this.spark().sql("drop table if exists dynamic_partition");
                this.spark().stop();
            }
            return assertion;
        }, new Position("BasicWriteJobStatsTrackerMetricSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
    }
}

