/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DateTimeBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final DateTimeBenchmark$ MODULE$ = new DateTimeBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        DateTimeBenchmark$ dateTimeBenchmark$ = this;
        synchronized (dateTimeBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    private void doBenchmark(int cardinality, Seq<String> exprs) {
        this.DatasetToBenchmark(this.spark().range((long)cardinality).selectExpr(exprs)).noop();
    }

    private void run(int cardinality, String name, Seq<String> exprs) {
        this.codegenBenchmark(name, cardinality, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.doBenchmark(cardinality, exprs));
    }

    private void run(int cardinality, String func) {
        this.codegenBenchmark(func + " of timestamp", cardinality, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.doBenchmark(cardinality, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{func + "(timestamp_seconds(id))"})));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)DateTimeTestUtils$.MODULE$.LA().getId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)Boolean.toString(true))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int N = 10000000;
            MODULE$.runBenchmark("datetime +/- interval", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$13 = "datetime +/- interval";
                long x$22 = N;
                Option x$32 = MODULE$.output();
                int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark("datetime +/- interval", x$22, x$42, x$52, x$62, x$72, x$32);
                String ts = "timestamp_seconds(id)";
                String dt = "cast(" + ts + " as date)";
                benchmark.addCase("date + interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " + interval 1 month"})));
                benchmark.addCase("date + interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " + interval 1 month 2 day"})));
                benchmark.addCase("date + interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " + interval 1 month 2 day 5 hour"})));
                benchmark.addCase("date - interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " - interval 1 month"})));
                benchmark.addCase("date - interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " - interval 1 month 2 day"})));
                benchmark.addCase("date - interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dt + " - interval 1 month 2 day 5 hour"})));
                benchmark.addCase("timestamp + interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " + interval 1 month"})));
                benchmark.addCase("timestamp + interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " + interval 1 month 2 day"})));
                benchmark.addCase("timestamp + interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " + interval 1 month 2 day 5 hour"})));
                benchmark.addCase("timestamp - interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " - interval 1 month"})));
                benchmark.addCase("timestamp - interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " - interval 1 month 2 day"})));
                benchmark.addCase("timestamp - interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> MODULE$.doBenchmark(N, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ts + " - interval 1 month 2 day 5 hour"})));
                benchmark.run();
            });
            MODULE$.runBenchmark("Extract components", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.run(N, "cast to timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp_seconds(id)"}));
                MODULE$.run(N, "year");
                MODULE$.run(N, "quarter");
                MODULE$.run(N, "month");
                MODULE$.run(N, "weekofyear");
                MODULE$.run(N, "day");
                MODULE$.run(N, "dayofyear");
                MODULE$.run(N, "dayofmonth");
                MODULE$.run(N, "dayofweek");
                MODULE$.run(N, "weekday");
                MODULE$.run(N, "hour");
                MODULE$.run(N, "minute");
                MODULE$.run(N, "second");
            });
            MODULE$.runBenchmark("Current date and time", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.run(N, "current_date", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current_date"}));
                MODULE$.run(N, "current_timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current_timestamp"}));
            });
            MODULE$.runBenchmark("Date arithmetic", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String dateExpr = "cast(timestamp_seconds(id) as date)";
                MODULE$.run(N, "cast to date", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dateExpr}));
                MODULE$.run(N, "last_day", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"last_day(" + dateExpr + ")"}));
                MODULE$.run(N, "next_day", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"next_day(" + dateExpr + ", 'TU')"}));
                MODULE$.run(N, "date_add", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date_add(" + dateExpr + ", 10)"}));
                MODULE$.run(N, "date_sub", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date_sub(" + dateExpr + ", 10)"}));
                MODULE$.run(N, "add_months", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"add_months(" + dateExpr + ", 10)"}));
            });
            MODULE$.runBenchmark("Formatting dates", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String dateExpr = "cast(timestamp_seconds(id) as date)";
                MODULE$.run(N, "format date", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date_format(" + dateExpr + ", 'MMM yyyy')"}));
            });
            MODULE$.runBenchmark("Formatting timestamps", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.run(N, "from_unixtime", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(id, 'yyyy-MM-dd HH:mm:ss.SSSSSS')"})));
            MODULE$.runBenchmark("Convert timestamps", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String timestampExpr = "timestamp_seconds(id)";
                MODULE$.run(N, "from_utc_timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from_utc_timestamp(" + timestampExpr + ", 'CET')"}));
                MODULE$.run(N, "to_utc_timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to_utc_timestamp(" + timestampExpr + ", 'CET')"}));
            });
            MODULE$.runBenchmark("Intervals", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2 tuple2 = new Tuple2((Object)"timestamp_seconds(id)", (Object)"timestamp_seconds(id+8640000)");
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String start = (String)tuple2._1();
                String end = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
                String start2 = (String)tuple22._1();
                String end2 = (String)tuple22._2();
                MODULE$.run(N, "cast interval", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{start2, end2}));
                MODULE$.run(N, "datediff", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"datediff(" + start2 + ", " + end2 + ")"}));
                MODULE$.run(N, "months_between", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"months_between(" + start2 + ", " + end2 + ")"}));
                MODULE$.run(1000000, "window", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window(" + start2 + ", 100, 10, 1)"}));
            });
            MODULE$.runBenchmark("Truncation", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String timestampExpr = "timestamp_seconds(id)";
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"YEAR", "YYYY", "YY", "MON", "MONTH", "MM", "DAY", "DD", "HOUR", "MINUTE", "SECOND", "WEEK", "QUARTER"})).foreach((Function1 & Serializable)level -> {
                    DateTimeBenchmark$.MODULE$.run(N, "date_trunc " + level, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date_trunc('" + level + "', " + timestampExpr + ")"}));
                    return BoxedUnit.UNIT;
                });
                String dateExpr = "cast(timestamp_seconds(id) as date)";
                new .colon.colon((Object)"year", (List)new .colon.colon((Object)"yyyy", (List)new .colon.colon((Object)"yy", (List)new .colon.colon((Object)"mon", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"mm", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)level -> {
                    DateTimeBenchmark$.MODULE$.run(N, "trunc " + level, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"trunc('" + level + "', " + dateExpr + ")"}));
                    return BoxedUnit.UNIT;
                });
            });
            MODULE$.runBenchmark("Parsing", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                int n = 1000000;
                String timestampStrExpr = "concat('2019-01-27 11:02:01.', cast(mod(id, 1000) as string))";
                String pattern = "'yyyy-MM-dd HH:mm:ss.SSS'";
                MODULE$.run(n, "to timestamp str", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{timestampStrExpr}));
                MODULE$.run(n, "to_timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to_timestamp(" + timestampStrExpr + ", " + pattern + ")"}));
                MODULE$.run(n, "to_unix_timestamp", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to_unix_timestamp(" + timestampStrExpr + ", " + pattern + ")"}));
                String dateStrExpr = "concat('2019-01-', lpad(mod(id, 25), 2, '0'))";
                MODULE$.run(n, "to date str", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dateStrExpr}));
                MODULE$.run(n, "to_date", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to_date(" + dateStrExpr + ", 'yyyy-MM-dd')"}));
            });
            MODULE$.runBenchmark("Conversion from/to external types", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                int rowsNum = 5000000;
                int numIters = 3;
                String x$8 = "To/from Java's date-time";
                long x$9 = rowsNum;
                Option x$10 = MODULE$.output();
                int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$142 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark("To/from Java's date-time", x$9, x$11, x$12, x$13, x$142, x$10);
                benchmark.addCase("From java.sql.Date", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable)millis -> new Date(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newDateEncoder())).noop());
                benchmark.addCase("From java.time.LocalDate", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable)millis -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(millis) / 86400000L), MODULE$.spark().implicits().newLocalDateEncoder())).noop());
                benchmark.addCase("Collect java.sql.Date", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> DateTimeBenchmark$.dates$1(rowsNum).collect());
                benchmark.addCase("Collect java.time.LocalDate", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> (LocalDate[])DateTimeBenchmark$.localDates$1(rowsNum).collect()));
                benchmark.addCase("From java.sql.Timestamp", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable)millis -> new Timestamp(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newTimeStampEncoder())).noop());
                benchmark.addCase("From java.time.Instant", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable)millis -> Instant.ofEpochMilli(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newInstantEncoder())).noop());
                benchmark.addCase("Collect longs", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).collect());
                benchmark.addCase("Collect java.sql.Timestamp", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> DateTimeBenchmark$.timestamps$1(rowsNum).collect());
                benchmark.addCase("Collect java.time.Instant", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$22 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> (Instant[])DateTimeBenchmark$.instants$1(rowsNum).collect()));
                benchmark.addCase("java.sql.Date to Hive string", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> DateTimeBenchmark$.toHiveString$1(DateTimeBenchmark$.dates$1(rowsNum)));
                benchmark.addCase("java.time.LocalDate to Hive string", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$24 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeBenchmark$.toHiveString$1(DateTimeBenchmark$.localDates$1(rowsNum))));
                benchmark.addCase("java.sql.Timestamp to Hive string", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$25 -> DateTimeBenchmark$.toHiveString$1(DateTimeBenchmark$.timestamps$1(rowsNum)));
                benchmark.addCase("java.time.Instant to Hive string", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$26 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeBenchmark$.toHiveString$1(DateTimeBenchmark$.instants$1(rowsNum))));
                benchmark.run();
            });
        }));
    }

    private static final Dataset dates$1(int rowsNum$1) {
        return MODULE$.spark().range(0L, (long)rowsNum$1, 1L, 1).map((Function1 & Serializable)millis -> new Date(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newDateEncoder());
    }

    private static final Dataset localDates$1(int rowsNum$1) {
        return MODULE$.spark().range(0L, (long)rowsNum$1, 1L, 1).map((Function1 & Serializable)millis -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(millis) / 86400000L), MODULE$.spark().implicits().newLocalDateEncoder());
    }

    private static final Dataset timestamps$1(int rowsNum$1) {
        return MODULE$.spark().range(0L, (long)rowsNum$1, 1L, 1).map((Function1 & Serializable)millis -> new Timestamp(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newTimeStampEncoder());
    }

    private static final Dataset instants$1(int rowsNum$1) {
        return MODULE$.spark().range(0L, (long)rowsNum$1, 1L, 1).map((Function1 & Serializable)millis -> Instant.ofEpochMilli(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newInstantEncoder());
    }

    private static final void toHiveString$1(Dataset df) {
        HiveResult$.MODULE$.hiveResultString(df.queryExecution().executedPlan());
    }

    private DateTimeBenchmark$() {
    }
}

