/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Iterator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.spark.SparkConf;
import org.apache.spark.TestUtils$;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.HadoopCompressionCodec;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.datasources.orc.OrcCompressionCodec;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompressionCodec;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class DataSourceReadBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final DataSourceReadBenchmark$ MODULE$ = new DataSourceReadBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        DataSourceReadBenchmark$ dataSourceReadBenchmark$ = this;
        synchronized (dataSourceReadBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    @Override
    public SparkSession getSparkSession() {
        SparkConf conf = new SparkConf().setAppName("DataSourceReadBenchmark").set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g");
        SparkSession sparkSession = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        sparkSession.conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        sparkSession.conf().set(SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), "true");
        sparkSession.conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
        return sparkSession;
    }

    public void withTempTable(scala.collection.immutable.Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)DataSourceReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition, boolean onlyParquetOrc) {
        DataFrameWriter testDf;
        DataFrameWriter dataFrameWriter = testDf = partition.isDefined() ? df.write().partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})) : df.write();
        if (!onlyParquetOrc) {
            this.saveAsCsvTable((DataFrameWriter<Row>)testDf, dir.getCanonicalPath() + "/csv");
            this.saveAsJsonTable((DataFrameWriter<Row>)testDf, dir.getCanonicalPath() + "/json");
        }
        this.saveAsParquetV1Table((DataFrameWriter<Row>)testDf, dir.getCanonicalPath() + "/parquetV1");
        this.saveAsParquetV2Table((DataFrameWriter<Row>)testDf, dir.getCanonicalPath() + "/parquetV2");
        this.saveAsOrcTable((DataFrameWriter<Row>)testDf, dir.getCanonicalPath() + "/orc");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    private boolean prepareTable$default$4() {
        return false;
    }

    private void saveAsCsvTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", HadoopCompressionCodec.GZIP.lowerCaseName()).option("header", true).csv(dir);
        this.spark().read().option("header", true).csv(dir).createOrReplaceTempView("csvTable");
    }

    private void saveAsJsonTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", HadoopCompressionCodec.GZIP.lowerCaseName()).json(dir);
        this.spark().read().json(dir).createOrReplaceTempView("jsonTable");
    }

    private void saveAsParquetV1Table(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", ParquetCompressionCodec.SNAPPY.lowerCaseName()).parquet(dir);
        this.spark().read().parquet(dir).createOrReplaceTempView("parquetV1Table");
    }

    private void saveAsParquetV2Table(DataFrameWriter<Row> df, String dir) {
        this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.writer.version"), (Object)ParquetProperties.WriterVersion.PARQUET_2_0.toString())}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            df.mode("overwrite").option("compression", ParquetCompressionCodec.SNAPPY.lowerCaseName()).parquet(dir);
            MODULE$.spark().read().parquet(dir).createOrReplaceTempView("parquetV2Table");
        });
    }

    private void saveAsOrcTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", OrcCompressionCodec.SNAPPY.lowerCaseName()).orc(dir);
        this.spark().read().orc(dir).createOrReplaceTempView("orcTable");
    }

    private void withParquetVersions(Function1<String, BoxedUnit> f) {
        new .colon.colon((Object)"V1", (List)new .colon.colon((Object)"V2", (List)Nil$.MODULE$)).foreach(f);
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        String x$1 = "SQL Single " + dataType.sql() + " Column Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark sqlBenchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        String x$8 = "Parquet Reader Single " + dataType.sql() + " Column Scan";
        long x$9 = values;
        Option x$10 = this.output();
        int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark parquetReaderBenchmark = new Benchmark(x$8, x$9, x$11, x$12, x$13, x$14, x$10);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$1(values, dataType, sqlBenchmark, parquetReaderBenchmark, dir);
            return BoxedUnit.UNIT;
        });
    }

    public void nestedNumericScanBenchmark(int values, DataType dataType) {
        String x$1 = "SQL Single " + dataType.sql() + " Column Scan in Struct";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark sqlBenchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                File x$8 = dir;
                Dataset x$9 = DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT named_struct('f', CAST(value as " + dataType$2.sql() + ")) as col FROM t1");
                boolean x$102 = true;
                Option<String> x$112 = DataSourceReadBenchmark$.MODULE$.prepareTable$default$3();
                DataSourceReadBenchmark$.MODULE$.prepareTable(x$8, (Dataset<Row>)x$9, x$112, true);
                sqlBenchmark$2.addCase("SQL ORC MR", sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(col.f) from orcTable")).noop()));
                sqlBenchmark$2.addCase("SQL ORC Vectorized (Nested Column Disabled)", sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(col.f) from orcTable")).noop()));
                sqlBenchmark$2.addCase("SQL ORC Vectorized (Nested Column Enabled)", sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(col.f) from orcTable")).noop()));
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    DataSourceReadBenchmark$.$anonfun$nestedNumericScanBenchmark$10(sqlBenchmark$2, version);
                    return BoxedUnit.UNIT;
                });
                sqlBenchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void nestedColumnScanBenchmark(int values) {
        String x$1 = "SQL Nested Column Scan";
        long x$2 = values;
        int x$3 = 10;
        Option x$4 = this.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("SQL Nested Column Scan", x$2, 10, x$5, x$6, x$7, x$4);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DataSourceReadBenchmark$.MODULE$.getClass().getClassLoader());
                public final class typecreator5.1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                    }

                    public typecreator5.1() {
                    }
                }
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).map((Function1 & Serializable)x -> DataSourceReadBenchmark$.$anonfun$nestedColumnScanBenchmark$4(BoxesRunTime.unboxToLong((Object)x)), DataSourceReadBenchmark$.MODULE$.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new typecreator5.1()))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1", "col2"})).createOrReplaceTempView("t1");
                File x$8 = dir;
                Dataset x$9 = DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1");
                boolean x$10 = true;
                Option<String> x$11 = DataSourceReadBenchmark$.MODULE$.prepareTable$default$3();
                DataSourceReadBenchmark$.MODULE$.prepareTable(x$8, (Dataset<Row>)x$9, x$11, true);
                benchmark$1.addCase("SQL ORC MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM orcTable")).noop()));
                benchmark$1.addCase("SQL ORC Vectorized (Nested Column Disabled)", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM orcTable")).noop()));
                benchmark$1.addCase("SQL ORC Vectorized (Nested Column Enabled)", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM orcTable")).noop()));
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    DataSourceReadBenchmark$.$anonfun$nestedColumnScanBenchmark$12(benchmark$1, version);
                    return BoxedUnit.UNIT;
                });
                benchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        String x$1 = "Int and String Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Int and String Scan", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$4).map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3(), DataSourceReadBenchmark$.MODULE$.prepareTable$default$4());
                benchmark$2.addCase("SQL CSV", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$25 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from csvTable")).noop());
                benchmark$2.addCase("SQL Json", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$26 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$2.addCase("SQL Parquet Vectorized: DataPage" + version, benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$27 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$2.addCase("SQL Parquet MR: DataPage" + version, benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$28 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$2.addCase("SQL ORC Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$29 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable")).noop());
                benchmark$2.addCase("SQL ORC MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$30 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable")).noop()));
                benchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        String x$1 = "Repeated String";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Repeated String", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$5).map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("select cast((value % 200) + 10000 as STRING) as c1 from t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3(), DataSourceReadBenchmark$.MODULE$.prepareTable$default$4());
                benchmark$3.addCase("SQL CSV", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$32 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from csvTable")).noop());
                benchmark$3.addCase("SQL Json", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$33 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$3.addCase("SQL Parquet Vectorized: DataPage" + version, benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$34 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$3.addCase("SQL Parquet MR: DataPage" + version, benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$35 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$3.addCase("SQL ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$36 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable")).noop());
                benchmark$3.addCase("SQL ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$37 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable")).noop()));
                benchmark$3.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        String x$1 = "Partitioned Table";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Partitioned Table", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable)x$38 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$4());
                benchmark$4.addCase("Data column - CSV", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$39 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from csvTable")).noop());
                benchmark$4.addCase("Data column - Json", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$40 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Data column - Parquet Vectorized: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$41 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Data column - Parquet MR: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$42 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$4.addCase("Data column - ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$43 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable")).noop());
                benchmark$4.addCase("Data column - ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$44 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable")).noop()));
                benchmark$4.addCase("Partition column - CSV", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$45 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from csvTable")).noop());
                benchmark$4.addCase("Partition column - Json", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$46 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Partition column - Parquet Vectorized: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$47 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Partition column - Parquet MR: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$48 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$4.addCase("Partition column - ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$49 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable")).noop());
                benchmark$4.addCase("Partition column - ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$50 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable")).noop()));
                benchmark$4.addCase("Both columns - CSV", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$51 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from csvTable")).noop());
                benchmark$4.addCase("Both columns - Json", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$52 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Both columns - Parquet Vectorized: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$53 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$4.addCase("Both columns - Parquet MR: DataPage" + version, benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$54 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$4.addCase("Both columns - ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$55 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable")).noop());
                benchmark$4.addCase("Both columns - ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$56 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable")).noop()));
                benchmark$4.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        double percentageOfNulls = fractionOfNulls * (double)100;
        String x$1 = "String with Nulls Scan (" + percentageOfNulls + "%)";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$7).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT IF(RAND(1) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c1, IF(RAND(2) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c2 FROM t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3(), DataSourceReadBenchmark$.MODULE$.prepareTable$default$4());
                benchmark$5.addCase("SQL CSV", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$57 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from csvTable where c1 is not NULL and c2 is not NULL")).noop());
                benchmark$5.addCase("SQL Json", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$58 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from jsonTable where c1 is not NULL and c2 is not NULL")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$5.addCase("SQL Parquet Vectorized: DataPage" + version, benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$59 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquet" + version + "Table where c1 is not NULL and c2 is not NULL")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$5.addCase("SQL Parquet MR: DataPage" + version, benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$60 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquet" + version + "Table where c1 is not NULL and c2 is not NULL")).noop()));
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    DataSourceReadBenchmark$.$anonfun$stringWithNullsScanBenchmark$10(dir, benchmark$5, version);
                    return BoxedUnit.UNIT;
                });
                benchmark$5.addCase("SQL ORC Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$62 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark$5.addCase("SQL ORC MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$63 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop()));
                benchmark$5.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        String x$1 = "Single Column Scan from " + width + " columns";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable)i -> DataSourceReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)));
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$8).map((Function1 & Serializable)x$64 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((scala.collection.immutable.Seq)selectExpr).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3(), DataSourceReadBenchmark$.MODULE$.prepareTable$default$4());
                benchmark$6.addCase("SQL CSV", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$65 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM csvTable")).noop());
                benchmark$6.addCase("SQL Json", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$66 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM jsonTable")).noop());
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$6.addCase("SQL Parquet Vectorized: DataPage" + version, benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$67 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM parquet" + version + "Table")).noop());
                    return BoxedUnit.UNIT;
                });
                DataSourceReadBenchmark$.MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                    benchmark$6.addCase("SQL Parquet MR: DataPage" + version, benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$68 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM parquet" + version + "Table")).noop()));
                    return BoxedUnit.UNIT;
                });
                benchmark$6.addCase("SQL ORC Vectorized", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$69 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM orcTable")).noop());
                benchmark$6.addCase("SQL ORC MR", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$70 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM orcTable")).noop()));
                benchmark$6.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("SQL Single Numeric Column Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)BooleanType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)dataType -> {
            DataSourceReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("SQL Single Numeric Column Scan in Struct", (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)dataType -> {
            DataSourceReadBenchmark$.MODULE$.nestedNumericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("SQL Nested Column Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.nestedColumnScanBenchmark(0x100000));
        this.runBenchmark("Int and String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.intStringScanBenchmark(0xA00000));
        this.runBenchmark("Repeated String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.repeatedStringScanBenchmark(0xA00000));
        this.runBenchmark("Partitioned Table Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.partitionTableScanBenchmark(0xF00000));
        this.runBenchmark("String with Nulls Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls)));
        this.runBenchmark("Single Column Scan From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable)() -> ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 100}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)columnWidth -> MODULE$.columnsBenchmark(0x100000, columnWidth)));
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$16(LongRef longSum$1, ColumnVector col, int i) {
        if (col.getBoolean(i)) {
            ++longSum$1.elem;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$17(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getByte(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$18(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getShort(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$19(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getInt(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$20(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += col.getLong(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$21(DoubleRef doubleSum$1, ColumnVector col, int i) {
        doubleSum$1.elem += (double)col.getFloat(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$22(DoubleRef doubleSum$1, ColumnVector col, int i) {
        doubleSum$1.elem += col.getDouble(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$23(boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, Function2 aggregateValue$1, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1);){
            reader.initialize(p, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$.$colon$colon((Object)"id")).asJava());
            ColumnarBatch batch = reader.resultBatch();
            ColumnVector col = batch.column(0);
            while (reader.nextBatch()) {
                int numRows = batch.numRows();
                for (int i = 0; i < numRows; ++i) {
                    Object object = !col.isNullAt(i) ? aggregateValue$1.apply((Object)col, (Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$14(File dir$2, Benchmark parquetReaderBenchmark$1, DataType dataType$1, boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, String version) {
        String[] files = TestUtils$.MODULE$.listDirectory(new File(dir$2, "parquet" + version));
        parquetReaderBenchmark$1.addCase("ParquetReader Vectorized: DataPage" + version, parquetReaderBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            Function2 & Serializable intersect;
            LongRef longSum = LongRef.create((long)0L);
            DoubleRef doubleSum = DoubleRef.create((double)0.0);
            DataType dataType = dataType$1;
            if (BooleanType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$16(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (ByteType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$17(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (ShortType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$18(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$19(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (LongType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$20(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (FloatType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$21(doubleSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                intersect = (Function2 & Serializable)(col, i) -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$22(doubleSum, col, BoxesRunTime.unboxToInt((Object)i));
                    return BoxedUnit.UNIT;
                };
            } else {
                throw new MatchError((Object)dataType);
            }
            Function2 & Serializable aggregateValue = intersect;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)p -> {
                DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$23(enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1, aggregateValue, p);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$26(LongRef longSum$2, InternalRow col) {
        if (col.getBoolean(0)) {
            ++longSum$2.elem;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$27(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getByte(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$28(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getShort(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$29(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getInt(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$30(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += col.getLong(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$31(DoubleRef doubleSum$2, InternalRow col) {
        doubleSum$2.elem += (double)col.getFloat(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$32(DoubleRef doubleSum$2, InternalRow col) {
        doubleSum$2.elem += col.getDouble(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$33(boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, Function1 aggregateValue$2, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1);){
            reader.initialize(p, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$.$colon$colon((Object)"id")).asJava());
            ColumnarBatch batch = reader.resultBatch();
            while (reader.nextBatch()) {
                Iterator it = batch.rowIterator();
                while (it.hasNext()) {
                    InternalRow record = (InternalRow)it.next();
                    Object object = !record.isNullAt(0) ? aggregateValue$2.apply((Object)record) : BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$24(File dir$2, Benchmark parquetReaderBenchmark$1, DataType dataType$1, boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, String version) {
        String[] files = TestUtils$.MODULE$.listDirectory(new File(dir$2, "parquet" + version));
        parquetReaderBenchmark$1.addCase("ParquetReader Vectorized -> Row: DataPage" + version, parquetReaderBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {
            Function1 & Serializable intersect;
            LongRef longSum = LongRef.create((long)0L);
            DoubleRef doubleSum = DoubleRef.create((double)0.0);
            DataType dataType = dataType$1;
            if (BooleanType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$26(longSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (ByteType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$27(longSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (ShortType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$28(longSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$29(longSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (LongType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$30(longSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (FloatType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$31(doubleSum, col);
                    return BoxedUnit.UNIT;
                };
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                intersect = (Function1 & Serializable)col -> {
                    DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$32(doubleSum, col);
                    return BoxedUnit.UNIT;
                };
            } else {
                throw new MatchError((Object)dataType);
            }
            Function1 & Serializable aggregateValue = intersect;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)p -> {
                DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$33(enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1, aggregateValue, p);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$1(int values$1, DataType dataType$1, Benchmark sqlBenchmark$1, Benchmark parquetReaderBenchmark$1, File dir) {
        MODULE$.withTempTable((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetV1Table", "parquetV2Table", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.spark().range((long)values$1).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
            MODULE$.prepareTable(dir, (Dataset<Row>)MODULE$.spark().sql("SELECT CAST(value as " + dataType$1.sql() + ") id FROM t1"), MODULE$.prepareTable$default$3(), MODULE$.prepareTable$default$4());
            DataType dataType = dataType$1;
            String query = BooleanType$.MODULE$.equals(dataType) ? "sum(cast(id as bigint))" : "sum(id)";
            sqlBenchmark$1.addCase("SQL CSV", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select " + query + " from csvTable")).noop());
            sqlBenchmark$1.addCase("SQL Json", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select " + query + " from jsonTable")).noop());
            MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                sqlBenchmark$1.addCase("SQL Parquet Vectorized: DataPage" + version, sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select " + query + " from parquet" + version + "Table")).noop());
                return BoxedUnit.UNIT;
            });
            MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                sqlBenchmark$1.addCase("SQL Parquet MR: DataPage" + version, sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> DataSourceReadBenchmark$.MODULE$.DatasetToBenchmark(DataSourceReadBenchmark$.MODULE$.spark().sql("select " + query + " from parquet" + version + "Table")).noop()));
                return BoxedUnit.UNIT;
            });
            sqlBenchmark$1.addCase("SQL ORC Vectorized", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("SELECT " + query + " FROM orcTable")).noop());
            sqlBenchmark$1.addCase("SQL ORC MR", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("SELECT " + query + " FROM orcTable")).noop()));
            sqlBenchmark$1.run();
            boolean enableOffHeapColumnVector = MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
            int vectorizedReaderBatchSize = MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
            MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$14(dir, parquetReaderBenchmark$1, dataType$1, enableOffHeapColumnVector, vectorizedReaderBatchSize, version);
                return BoxedUnit.UNIT;
            });
            MODULE$.withParquetVersions((Function1<String, BoxedUnit>)(Function1 & Serializable)version -> {
                DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$24(dir, parquetReaderBenchmark$1, dataType$1, enableOffHeapColumnVector, vectorizedReaderBatchSize, version);
                return BoxedUnit.UNIT;
            });
        });
        parquetReaderBenchmark$1.run();
    }

    public static final /* synthetic */ void $anonfun$nestedNumericScanBenchmark$10(Benchmark sqlBenchmark$2, String version) {
        sqlBenchmark$2.addCase("SQL Parquet MR: DataPage" + version, sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select sum(col.f) from parquet" + version + "Table")).noop()));
        sqlBenchmark$2.addCase("SQL Parquet Vectorized: DataPage" + version + " (Nested Column Disabled)", sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select sum(col.f) from parquet" + version + "Table")).noop()));
        sqlBenchmark$2.addCase("SQL Parquet Vectorized: DataPage" + version + " (Nested Column Enabled)", sqlBenchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("select sum(col.f) from parquet" + version + "Table")).noop()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$nestedColumnScanBenchmark$5(long x$71, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(x$71 + (long)i)), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x$71))), 5));
    }

    public static final /* synthetic */ Tuple2 $anonfun$nestedColumnScanBenchmark$4(long x) {
        IndexedSeq arrayOfStructColumn = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> DataSourceReadBenchmark$.$anonfun$nestedColumnScanBenchmark$5(x, BoxesRunTime.unboxToInt((Object)i)));
        Map mapOfStructColumn = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(BoxesRunTime.boxToLong((long)x))), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)x * 0.1)), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)x), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x))), 100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x))), 2)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)x * 0.2)), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)x), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x))), 200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x))), 3)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)x * 0.3)), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)x), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(BoxesRunTime.boxToLong((long)x))), 300))))}));
        return new Tuple2((Object)arrayOfStructColumn, (Object)mapOfStructColumn);
    }

    public static final /* synthetic */ void $anonfun$nestedColumnScanBenchmark$12(Benchmark benchmark$1, String version) {
        benchmark$1.addCase("SQL Parquet MR: DataPage" + version, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM parquet" + version + "Table")).noop()));
        benchmark$1.addCase("SQL Parquet Vectorized: DataPage" + version + " (Nested Column Disabled)", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$22 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM parquet" + version + "Table")).noop()));
        benchmark$1.addCase("SQL Parquet Vectorized: DataPage" + version + " (Nested Column Enabled)", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> MODULE$.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql("SELECT SUM(SIZE(col1)), SUM(SIZE(col2)) FROM parquet" + version + "Table")).noop()));
    }

    public static final /* synthetic */ void $anonfun$stringWithNullsScanBenchmark$12(boolean enableOffHeapColumnVector$2, int vectorizedReaderBatchSize$2, IntRef sum$1, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(enableOffHeapColumnVector$2, vectorizedReaderBatchSize$2);){
            reader.initialize(p, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$.$colon$colon((Object)"c2").$colon$colon((Object)"c1")).asJava());
            ColumnarBatch batch = reader.resultBatch();
            while (reader.nextBatch()) {
                Iterator rowIterator = batch.rowIterator();
                while (rowIterator.hasNext()) {
                    InternalRow row = (InternalRow)rowIterator.next();
                    UTF8String value = row.getUTF8String(0);
                    if (row.isNullAt(0) || row.isNullAt(1)) continue;
                    sum$1.elem += value.numBytes();
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$stringWithNullsScanBenchmark$10(File dir$8, Benchmark benchmark$5, String version) {
        String[] files = TestUtils$.MODULE$.listDirectory(new File(dir$8, "parquet" + version));
        boolean enableOffHeapColumnVector = MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
        int vectorizedReaderBatchSize = MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
        benchmark$5.addCase("ParquetReader Vectorized: DataPage" + version, benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$61 -> {
            IntRef sum = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)p -> {
                DataSourceReadBenchmark$.$anonfun$stringWithNullsScanBenchmark$12(enableOffHeapColumnVector, vectorizedReaderBatchSize, sum, p);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return "value as c" + i;
    }

    private DataSourceReadBenchmark$() {
    }
}

