/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SQLExecutionSuite$;
import org.apache.spark.sql.execution.SQLExecutionSuite$$anon$1$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.parallel.immutable.ParRange;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005E3AAC\u0006\u0001-!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0005A\u001d)Af\u0003E\u0001[\u0019)!b\u0003E\u0001]!)1\u0004\u0002C\u0001u!91\b\u0002a\u0001\n\u0003a\u0004b\u0002!\u0005\u0001\u0004%\t!\u0011\u0005\u0007\t\u0012\u0001\u000b\u0015B\u001f\t\u000f%#\u0011\u0011!C\u0005\u0015\n\t2+\u0015'Fq\u0016\u001cW\u000f^5p]N+\u0018\u000e^3\u000b\u00051i\u0011!C3yK\u000e,H/[8o\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0006\u00029Q,7\u000f^\"p]\u000e,(O]3oiF+XM]=Fq\u0016\u001cW\u000f^5p]R\u0011\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)\u0005\u0001\u0007\u0011&\u0001\u0002tGB\u0011\u0001DK\u0005\u0003W=\u0011Ab\u00159be.\u001cuN\u001c;fqR\f\u0011cU)M\u000bb,7-\u001e;j_:\u001cV/\u001b;f!\tqBaE\u0002\u0005_I\u0002\"A\t\u0019\n\u0005E\u001a#AB!osJ+g\r\u0005\u00024q5\tAG\u0003\u00026m\u0005\u0011\u0011n\u001c\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001.\u0003-\u0019\u0017M\u001c)s_\u001e\u0014Xm]:\u0016\u0003u\u0002\"A\t \n\u0005}\u001a#a\u0002\"p_2,\u0017M\\\u0001\u0010G\u0006t\u0007K]8he\u0016\u001c8o\u0018\u0013fcR\u0011\u0011E\u0011\u0005\b\u0007\u001e\t\t\u00111\u0001>\u0003\rAH%M\u0001\rG\u0006t\u0007K]8he\u0016\u001c8\u000f\t\u0015\u0003\u0011\u0019\u0003\"AI$\n\u0005!\u001b#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u001c\u0002\t1\fgnZ\u0005\u0003!6\u0013aa\u00142kK\u000e$\b")
public class SQLExecutionSuite
extends SparkFunSuite {
    public static void canProgress_$eq(boolean x$1) {
        SQLExecutionSuite$.MODULE$.canProgress_$eq(x$1);
    }

    public static boolean canProgress() {
        return SQLExecutionSuite$.MODULE$.canProgress();
    }

    private void testConcurrentQueryExecution(SparkContext sc) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        sc.getLocalProperties();
        ObjectRef throwable = ObjectRef.create((Object)None$.MODULE$);
        Thread child = new Thread(null, spark, sc, throwable){
            private final SparkSession spark$2;
            private final SparkContext sc$1;
            private final ObjectRef throwable$1;

            public void run() {
                try {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror($anon$1.class.getClassLoader());
                    public final class Org_apache_spark_sql_execution_SQLExecutionSuite$$anon$1$$typecreator10$2
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public Org_apache_spark_sql_execution_SQLExecutionSuite$$anon$1$$typecreator10$2($anon$1 $outer) {
                        }
                    }
                    this.spark$2.implicits().rddToDatasetHolder(this.sc$1.parallelize((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100), this.sc$1.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)i -> $anon$1.$anonfun$run$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), this.spark$2.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_SQLExecutionSuite$$anon$1$$typecreator10$2(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).collect();
                }
                catch (Throwable t) {
                    this.throwable$1.elem = new Some((Object)t);
                }
            }

            public static final /* synthetic */ Tuple2 $anonfun$run$1(int i) {
                return new Tuple2.mcII.sp(i, i);
            }
            {
                this.spark$2 = spark$2;
                this.sc$1 = sc$1;
                this.throwable$1 = throwable$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(java.lang.Object )}, serializedLambda);
            }
        };
        sc.setLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY(), "anything");
        child.start();
        child.join();
        ((Option)throwable.elem).foreach((Function1 & Serializable)t -> {
            t.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace()), (Object)Thread.currentThread().getStackTrace(), ClassTag$.MODULE$.apply(StackTraceElement.class)));
            throw t;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$4(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ void $anonfun$new$8(SQLExecutionSuite $this, ObjectRef session$1, ExecutorService executor1$1, ExecutorService executor2$1, File tempDir) {
        try {
            String tablePath = tempDir.toString() + "/table";
            Dataset df = (Dataset)ThreadUtils$.MODULE$.awaitResult((Awaitable)Future$.MODULE$.apply((Function0 & Serializable)() -> {
                session$1.elem = SparkSession$.MODULE$.builder().appName("test").master("local[*]").getOrCreate();
                SparkContext qual$1 = ((SparkSession)session$1.elem).sparkContext();
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new int[]{1, 2, 3}}));
                List x$1 = Nil$.MODULE$.$colon$colon((Object)row);
                int x$2 = qual$1.parallelize$default$2();
                ((SparkSession)session$1.elem).createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).write().parquet(tablePath);
                return ((SparkSession)session$1.elem).read().parquet(tablePath);
            }, (ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService(executor1$1)), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute());
            ThreadUtils$.MODULE$.awaitResult((Awaitable)Future$.MODULE$.apply((Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(((Row[])df.rdd().collect())[0]);
                Row $org_scalatest_assert_macro_right = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            }, (ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService(executor2$1)), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute());
        }
        finally {
            executor1$1.shutdown();
            executor2$1.shutdown();
            ((SparkSession)session$1.elem).stop();
        }
    }

    public SQLExecutionSuite() {
        this.test("concurrent query execution (SPARK-10548)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            SparkConf conf = new SparkConf().setMaster("local[*]").setAppName("test");
            SparkContext goodSparkContext = new SparkContext(conf);
            try {
                this.testConcurrentQueryExecution(goodSparkContext);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                goodSparkContext.stop();
            }
            return boxedUnit;
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("concurrent query execution with fork-join pool (SPARK-13747)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("test").getOrCreate();
            try {
                new ParRange((Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100)).foreach((Function1)(JFunction1.mcJI.sp & Serializable)x$1 -> {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SQLExecutionSuite.class.getClassLoader());
                    public final class Org_apache_spark_sql_execution_SQLExecutionSuite$$typecreator10$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public Org_apache_spark_sql_execution_SQLExecutionSuite$$typecreator10$1(SQLExecutionSuite $outer) {
                        }
                    }
                    return spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5), spark.sparkContext().parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)i -> SQLExecutionSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_SQLExecutionSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).count();
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                spark.sparkContext().stop();
            }
            return boxedUnit;
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Finding QueryExecution for given executionId", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("test").getOrCreate();
            ObjectRef queryExecution = ObjectRef.create(null);
            spark.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(null, queryExecution){
                private final ObjectRef queryExecution$1;

                public void onJobStart(SparkListenerJobStart jobStart) {
                    String executionIdStr = jobStart.properties().getProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                    if (executionIdStr != null) {
                        this.queryExecution$1.elem = SQLExecution$.MODULE$.getQueryExecution(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionIdStr)));
                    }
                    SQLExecutionSuite$.MODULE$.canProgress_$eq(true);
                }
                {
                    this.queryExecution$1 = queryExecution$1;
                }
            });
            Dataset df = spark.range(1L).map((Function1 & Serializable)x -> {
                while (!SQLExecutionSuite$.MODULE$.canProgress()) {
                    Thread.sleep(1L);
                }
                return x;
            }, spark.implicits().newBoxedLongEncoder());
            df.collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.queryExecution());
            QueryExecution $org_scalatest_assert_macro_right = (QueryExecution)queryExecution.elem;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            spark.stop();
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("SPARK-32813: Table scan should work in different thread", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExecutorService executor1 = Executors.newSingleThreadExecutor();
            ExecutorService executor2 = Executors.newSingleThreadExecutor();
            ObjectRef session = ObjectRef.create(null);
            SparkSession$.MODULE$.cleanupAnyExistingSession();
            this.withTempDir((Function1 & Serializable)tempDir -> {
                SQLExecutionSuite.$anonfun$new$8(this, session, executor1, executor2, tempDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("SPARK-34735: Add modified configs for SQL execution in UI", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("test").config("k1", "v1").config("spark.driver.extraJavaOptions", "-Dkey=value").getOrCreate();
            try {
                AtomicInteger index = new AtomicInteger(0);
                spark.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(null, index){
                    private final AtomicInteger index$1;

                    public void onOtherEvent(SparkListenerEvent event) {
                        SparkListenerEvent sparkListenerEvent = event;
                        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
                            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
                            if (this.index$1.get() == 0 && this.hasProject(sparkListenerSQLExecutionStart)) {
                                Map $org_scalatest_assert_macro_left = sparkListenerSQLExecutionStart.modifiedConfigs();
                                String $org_scalatest_assert_macro_right = "k1";
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
                                this.index$1.incrementAndGet();
                                return;
                            }
                            if (this.index$1.get() == 1 && this.hasProject(sparkListenerSQLExecutionStart)) {
                                Map $org_scalatest_assert_macro_left = sparkListenerSQLExecutionStart.modifiedConfigs();
                                String $org_scalatest_assert_macro_right = "k2";
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
                                String $org_scalatest_assert_macro_left2 = (String)sparkListenerSQLExecutionStart.modifiedConfigs().apply((Object)"k2");
                                String $org_scalatest_assert_macro_right2 = "v2";
                                String string = $org_scalatest_assert_macro_left2;
                                String string2 = $org_scalatest_assert_macro_right2;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                                Map $org_scalatest_assert_macro_left3 = sparkListenerSQLExecutionStart.modifiedConfigs();
                                String $org_scalatest_assert_macro_right3 = "redaction.password";
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                                String $org_scalatest_assert_macro_left4 = (String)sparkListenerSQLExecutionStart.modifiedConfigs().apply((Object)"redaction.password");
                                String $org_scalatest_assert_macro_right4 = Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT();
                                String string3 = $org_scalatest_assert_macro_left4;
                                String string4 = $org_scalatest_assert_macro_right4;
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                                Map $org_scalatest_assert_macro_left5 = sparkListenerSQLExecutionStart.modifiedConfigs();
                                String $org_scalatest_assert_macro_right5 = "spark.driver.extraJavaOptions";
                                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
                                this.index$1.incrementAndGet();
                                return;
                            }
                            return;
                        }
                    }

                    private boolean hasProject(SparkListenerSQLExecutionStart start) {
                        return start.physicalPlanDescription().toLowerCase(Locale.ROOT).contains("project");
                    }
                    {
                        this.index$1 = index$1;
                    }
                });
                spark.sql("SELECT 1").collect();
                spark.sql("SET k2 = v2");
                spark.sql("SET redaction.password = 123");
                spark.sql("SELECT 1").collect();
                spark.sparkContext().listenerBus().waitUntilEmpty();
                int $org_scalatest_assert_macro_left = index.get();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            }
            finally {
                spark.stop();
            }
            return assertion;
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("SPARK-44591: jobTags property", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession spark = SparkSession$.MODULE$.builder().master("local[*]").appName("test").getOrCreate();
            String jobTag = "jobTag";
            try {
                spark.sparkContext().addJobTag(jobTag);
                ObjectRef jobTags = ObjectRef.create((Object)None$.MODULE$);
                ObjectRef sqlJobTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
                spark.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(null, jobTags, sqlJobTags){
                    private final ObjectRef jobTags$1;
                    private final ObjectRef sqlJobTags$1;

                    public void onJobStart(SparkListenerJobStart jobStart) {
                        this.jobTags$1.elem = new Some((Object)jobStart.properties().getProperty(SparkContext$.MODULE$.SPARK_JOB_TAGS()));
                    }

                    public void onOtherEvent(SparkListenerEvent event) {
                        SparkListenerEvent sparkListenerEvent = event;
                        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
                            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
                            this.sqlJobTags$1.elem = sparkListenerSQLExecutionStart.jobTags();
                            return;
                        }
                        throw new MatchError((Object)sparkListenerEvent);
                    }
                    {
                        this.jobTags$1 = jobTags$1;
                        this.sqlJobTags$1 = sqlJobTags$1;
                    }
                });
                spark.range(1L).collect();
                Option $org_scalatest_assert_macro_left = (Option)jobTags.elem;
                String $org_scalatest_assert_macro_right = jobTag;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
                Set $org_scalatest_assert_macro_left2 = (Set)sqlJobTags.elem;
                String $org_scalatest_assert_macro_right2 = jobTag;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            }
            finally {
                spark.sparkContext().removeJobTag(jobTag);
                spark.stop();
            }
            return assertion;
        }, new Position("SQLExecutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }
}

