/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.RowToColumnConverter;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\tI\"k\\<U_\u000e{G.^7o\u0007>tg/\u001a:uKJ\u001cV/\u001b;f\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u0003-\u0019wN\u001c<feR\u0014vn^:\u0015\u0007iqs\u0007E\u0002\u001cK!r!\u0001\b\u0012\u000f\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011A\u0002\u001fs_>$h(C\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019C%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0005J!AJ\u0014\u0003\u0007M+\u0017O\u0003\u0002$IA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017BA\u0017+\u0005Q9&/\u001b;bE2,7i\u001c7v[:4Vm\u0019;pe\")qF\u0001a\u0001a\u0005!!o\\<t!\rYR%\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0003mM\u00121\"\u00138uKJt\u0017\r\u001c*po\")\u0001H\u0001a\u0001s\u000511o\u00195f[\u0006\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0004\u0002\u000bQL\b/Z:\n\u0005yZ$AC*ueV\u001cG\u000fV=qK\u0002")
public class RowToColumnConverterSuite
extends SparkFunSuite {
    public scala.collection.immutable.Seq<WritableColumnVector> convertRows(scala.collection.immutable.Seq<InternalRow> rows, StructType schema) {
        RowToColumnConverter converter = new RowToColumnConverter(schema);
        WritableColumnVector[] vectors = (WritableColumnVector[])((IterableOnceOps)schema.map((Function1 & Serializable)f -> new OnHeapColumnVector(5, f.dataType()))).toArray(ClassTag$.MODULE$.apply(WritableColumnVector.class));
        rows.foreach((Function1 & Serializable)row -> {
            converter.convert(row, vectors);
            return BoxedUnit.UNIT;
        });
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)vectors).toImmutableArraySeq();
    }

    public static final /* synthetic */ Object $anonfun$new$9(int j) {
        if (j % 3 == 0) {
            return null;
        }
        return BoxesRunTime.boxToInteger((int)j);
    }

    public static final /* synthetic */ GenericArrayData $anonfun$new$13(int j) {
        return new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), j));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$19(int j) {
        return UTF8String.fromString((String)("str" + j));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$23(int j) {
        if (j % 3 == 0) {
            return null;
        }
        return UTF8String.fromString((String)("str" + j));
    }

    public RowToColumnConverterSuite() {
        this.test("integer column", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("i", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ColumnVector)vectors.head()).getInt(i)));
                    int $org_scalatest_assert_macro_right = row.getInt(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("array column", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("a", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i)))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(((WritableColumnVector)vectors.head()).getArray(i).array()).array());
                    Object[] $org_scalatest_assert_macro_right = row.getArray(0).array();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("non-nullable array column with null elements", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayType arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("a", (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i)).map((Function1 & Serializable)j -> RowToColumnConverterSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)j))))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(((WritableColumnVector)vectors.head()).getArray(i).array()).array());
                    Object[] $org_scalatest_assert_macro_right = row.getArray(0).array();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("nested array column", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("a", (DataType)arrayType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i)).map((Function1 & Serializable)j -> RowToColumnConverterSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)j))))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Object[][] result = (Object[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Predef$.MODULE$.wrapRefArray(((WritableColumnVector)vectors.head()).getArray(i).array()).array()), (Function1 & Serializable)x$1 -> ((ArrayData)x$1).array(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
                    Object[][] expected = (Object[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)row.getArray(0).array()), (Function1 & Serializable)x$2 -> ((ArrayData)x$2).array(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
                    Object[][] $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("map column", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("m", (DataType)mapType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayBasedMapData((ArrayData)new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i))), (ArrayData)new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i)).map((Function1 & Serializable)j -> RowToColumnConverterSuite.$anonfun$new$19(BoxesRunTime.unboxToInt((Object)j)))))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ColumnarMap result = ((WritableColumnVector)vectors.head()).getMap(i);
                    MapData expected = row.getMap(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(result.keyArray().array()).array());
                    Object[] $org_scalatest_assert_macro_right = expected.keyArray().array();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(result.valueArray().array()).array());
                    Object[] $org_scalatest_assert_macro_right2 = expected.valueArray().array();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("non-nullable map column with null values", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType mapType = new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true);
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("m", (DataType)mapType, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayBasedMapData((ArrayData)new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i))), (ArrayData)new GenericArrayData((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)i)).map((Function1 & Serializable)j -> RowToColumnConverterSuite.$anonfun$new$23(BoxesRunTime.unboxToInt((Object)j)))))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ColumnarMap result = ((WritableColumnVector)vectors.head()).getMap(i);
                    MapData expected = row.getMap(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(result.keyArray().array()).array());
                    Object[] $org_scalatest_assert_macro_right = expected.keyArray().array();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray(result.valueArray().array()).array());
                    Object[] $org_scalatest_assert_macro_right2 = expected.valueArray().array();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("multiple columns", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("s", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("i", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("l", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            IndexedSeq rows = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)(3 * BoxesRunTime.unboxToInt((Object)i)))), BoxesRunTime.boxToInteger((int)(3 * BoxesRunTime.unboxToInt((Object)i) + 1)), BoxesRunTime.boxToLong((long)(3 * BoxesRunTime.unboxToInt((Object)i) + 2))})));
            scala.collection.immutable.Seq<WritableColumnVector> vectors = this.convertRows((scala.collection.immutable.Seq<InternalRow>)rows, schema);
            return (IndexedSeq)((IndexedSeqOps)rows.zipWithIndex()).map((Function1 & Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 != null) {
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToShort((short)((ColumnVector)vectors.apply(0)).getShort(i)));
                    short $org_scalatest_assert_macro_right = row.getShort(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ColumnVector)vectors.apply(1)).getInt(i)));
                    int $org_scalatest_assert_macro_right2 = row.getInt(1);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((ColumnVector)vectors.apply(2)).getLong(i)));
                    long $org_scalatest_assert_macro_right3 = row.getLong(2);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("RowToColumnConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }
}

