/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.CoalescedShuffleRead$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t4AAD\b\u00015!)q\u0004\u0001C\u0001A!I1\u0005\u0001a\u0001\u0002\u0004%I\u0001\n\u0005\n_\u0001\u0001\r\u00111A\u0005\nAB\u0011B\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0013\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0013!\u0003\"\u0003\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003:\u0011%Y\u0004\u00011A\u0001B\u0003&Q\u0005C\u0003=\u0001\u0011ES\bC\u0003?\u0001\u0011ES\bC\u0004@\u0001\t\u0007I\u0011\u0001!\t\r\u0011\u0003\u0001\u0015!\u0003B\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001d1\u0006!%A\u0005\u0002]\u0013adQ8bY\u0016\u001c8-Z*ik\u001a4G.\u001a)beRLG/[8ogN+\u0018\u000e^3\u000b\u0005A\t\u0012!C3yK\u000e,H/[8o\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\t1#\u0003\u0002\u001f'\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\b\u00025=\u0014\u0018nZ5oC2\f5\r^5wKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003\u0015\u00022AJ\u0015,\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB(qi&|g\u000e\u0005\u0002-[5\t\u0011#\u0003\u0002/#\ta1\u000b]1sWN+7o]5p]\u0006qrN]5hS:\fG.Q2uSZ,7\u000b]1sWN+7o]5p]~#S-\u001d\u000b\u0003cQ\u0002\"A\n\u001a\n\u0005M:#\u0001B+oSRDq!N\u0002\u0002\u0002\u0003\u0007Q%A\u0002yIE\n1d\u001c:jO&t\u0017\r\\!di&4Xm\u00159be.\u001cVm]:j_:\u0004\u0013\u0001I8sS\u001eLg.\u00197J]N$\u0018M\u001c;jCR,Gm\u00159be.\u001cVm]:j_:\fAe\u001c:jO&t\u0017\r\\%ogR\fg\u000e^5bi\u0016$7\u000b]1sWN+7o]5p]~#S-\u001d\u000b\u0003ciBq!\u000e\u0004\u0002\u0002\u0003\u0007Q%A\u0011pe&<\u0017N\\1m\u0013:\u001cH/\u00198uS\u0006$X\rZ*qCJ\\7+Z:tS>t\u0007%A\u0005cK\u001a|'/Z!mYR\t\u0011'\u0001\u0005bMR,'/\u00117m\u0003IqW/\\%oaV$\b+\u0019:uSRLwN\\:\u0016\u0003\u0005\u0003\"A\n\"\n\u0005\r;#aA%oi\u0006\u0019b.^7J]B,H\u000fU1si&$\u0018n\u001c8tA\u0005\u0001r/\u001b;i'B\f'o[*fgNLwN\u001c\u000b\u0006c\u001dce*\u0015\u0005\u0006\u00112\u0001\r!S\u0001\u0002MB!aES\u00162\u0013\tYuEA\u0005Gk:\u001cG/[8oc!)Q\n\u0004a\u0001\u0003\u0006QB/\u0019:hKR\u0004vn\u001d;TQV4g\r\\3J]B,HoU5{K\")q\n\u0004a\u0001!\u0006YR.\u001b8Ok6\u0004vn\u001d;TQV4g\r\\3QCJ$\u0018\u000e^5p]N\u00042AJ\u0015B\u0011\u001d\u0011F\u0002%AA\u0002M\u000b!#\u001a8bE2,\u0017jT#oGJL\b\u000f^5p]B\u0011a\u0005V\u0005\u0003+\u001e\u0012qAQ8pY\u0016\fg.\u0001\u000exSRD7\u000b]1sWN+7o]5p]\u0012\"WMZ1vYR$C'F\u0001YU\t\u0019\u0016lK\u0001[!\tY\u0006-D\u0001]\u0015\tif,A\u0005v]\u000eDWmY6fI*\u0011qlJ\u0001\u000bC:tw\u000e^1uS>t\u0017BA1]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CoalesceShufflePartitionsSuite
extends SparkFunSuite {
    private Option<SparkSession> originalActiveSparkSession;
    private Option<SparkSession> originalInstantiatedSparkSession;
    private final int numInputPartitions;

    private Option<SparkSession> originalActiveSparkSession() {
        return this.originalActiveSparkSession;
    }

    private void originalActiveSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalActiveSparkSession = x$1;
    }

    private Option<SparkSession> originalInstantiatedSparkSession() {
        return this.originalInstantiatedSparkSession;
    }

    private void originalInstantiatedSparkSession_$eq(Option<SparkSession> x$1) {
        this.originalInstantiatedSparkSession = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.originalActiveSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getActiveSession());
        this.originalInstantiatedSparkSession_$eq((Option<SparkSession>)SparkSession$.MODULE$.getDefaultSession());
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.clearDefaultSession();
    }

    public void afterAll() {
        try {
            this.originalActiveSparkSession().foreach((Function1 & Serializable)ctx -> {
                SparkSession$.MODULE$.setActiveSession(ctx);
                return BoxedUnit.UNIT;
            });
            this.originalInstantiatedSparkSession().foreach((Function1 & Serializable)ctx -> {
                SparkSession$.MODULE$.setDefaultSession(ctx);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            super.afterAll();
        }
    }

    public int numInputPartitions() {
        return this.numInputPartitions;
    }

    public void withSparkSession(Function1<SparkSession, BoxedUnit> f, int targetPostShuffleInputSize, Option<Object> minNumPostShufflePartitions, boolean enableIOEncryption) {
        SparkConf sparkConf = new SparkConf(false).setMaster("local[*]").setAppName("test").set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false)).set(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)enableIOEncryption)).set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "5").set(SQLConf$.MODULE$.COALESCE_PARTITIONS_INITIAL_PARTITION_NUM().key(), "5").set(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key(), "true").set(SQLConf$.MODULE$.FETCH_SHUFFLE_BLOCKS_IN_BATCH().key(), "true").set(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1").set(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), Integer.toString(targetPostShuffleInputSize));
        Option<Object> option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            sparkConf.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), Integer.toString(numPartitions));
        } else if (None$.MODULE$.equals(option)) {
            sparkConf.set(SQLConf$.MODULE$.COALESCE_PARTITIONS_MIN_PARTITION_NUM().key(), "1");
        } else {
            throw new MatchError(option);
        }
        SparkSession spark = SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate();
        try {
            f.apply((Object)spark);
        }
        finally {
            spark.stop();
        }
    }

    public boolean withSparkSession$default$4() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$3(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 20 as key", "id as value"}));
        Dataset agg = df.groupBy("key", (Seq)Nil$.MODULE$).count();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)agg, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(spark.range(0L, 20L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "50 as cnt"})).collect()).toImmutableArraySeq(), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)agg.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x1;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x1;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$new$6(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})).union(spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "id as value"})));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(expectedAnswer.collect()).toImmutableArraySeq(), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x2;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x2;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$new$9(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"})).groupBy("key2", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key2", "cnt2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt2")}));
        Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "2 as cnt"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(expectedAnswer.collect()).toImmutableArraySeq(), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x3;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(SparkPlan x3) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x3;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$new$12(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions$1, SparkSession spark) {
        Dataset df1 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key1", "id as value1"})).groupBy("key1", (Seq)Nil$.MODULE$).count().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "cnt1"}));
        Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
        Dataset join = df1.join(df2, functions$.MODULE$.col("key1").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key1"), functions$.MODULE$.col("cnt1"), functions$.MODULE$.col("value2")}));
        Dataset expectedAnswer = spark.range(0L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key", "2 as cnt", "id as value"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(expectedAnswer.collect()).toImmutableArraySeq(), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
        Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x4;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(SparkPlan x4) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x4;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        Option option = minNumPostShufflePartitions$1;
        if (option instanceof Some) {
            Seq $org_scalatest_assert_macro_left = shuffleReads;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            shuffleReads.foreach((Function1 & Serializable)read -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)read.outputPartitioning().numPartitions()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$new$15(CoalesceShufflePartitionsSuite $this, SparkSession spark) {
        try {
            spark.range(1000L).write().bucketBy(30, "id", (Seq)Nil$.MODULE$).saveAsTable("t");
            Dataset df1 = spark.read().table("t");
            Dataset df2 = spark.range(0L, 1000L, 1L, $this.numInputPartitions()).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500 as key2", "id as value2"}));
            Dataset join = df1.join(df2, functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.col("key2"))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("value2")}));
            Dataset expectedAnswer = spark.range(0L, 500L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})).union(spark.range(500L, 1000L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id % 500", "id as value"})));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)join, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(expectedAnswer.collect()).toImmutableArraySeq(), QueryTest$.MODULE$.checkAnswer$default$3());
            SparkPlan finalPlan = ((AdaptiveSparkPlanExec)join.queryExecution().executedPlan()).executedPlan();
            Seq shuffleReads = finalPlan.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    A1 A1 = x5;
                    if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                        return (B1)aQEShuffleReadExec;
                    }
                    return (B1)function1.apply(x5);
                }

                public final boolean isDefinedAt(SparkPlan x5) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    SparkPlan sparkPlan2 = x5;
                    return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shuffleReads.length()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        }
        finally {
            spark.sql("drop table t");
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(CoalesceShufflePartitionsSuite $this, Option minNumPostShufflePartitions) {
        Object object;
        Option option = minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            object = "(minNumPostShufflePartitions: " + numPartitions + ")";
        } else if (None$.MODULE$.equals(option)) {
            object = "";
        } else {
            throw new MatchError((Object)option);
        }
        String testNameNote = object;
        $this.test("determining the number of reducers: aggregate operator" + testNameNote, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$3($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 2000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        $this.test("determining the number of reducers: join operator" + testNameNote, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$6($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        $this.test("determining the number of reducers: complex query 1" + testNameNote, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$9($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 16384, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        $this.test("determining the number of reducers: complex query 2" + testNameNote, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$12($this, minNumPostShufflePartitions, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        $this.test("determining the number of reducers: plan already partitioned" + testNameNote, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$15($this, spark);
                return BoxedUnit.UNIT;
            };
            $this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 12000, (Option<Object>)minNumPostShufflePartitions, $this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public static final /* synthetic */ void $anonfun$new$17(SparkSession spark) {
        Seq reusedStages;
        Seq leafStages;
        Seq level1Stages;
        spark.sql("SET spark.sql.exchange.reuse=true");
        Dataset df = spark.range(0L, 6L, 1L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id AS key", "id AS value"}));
        Dataset resultDf = df.join(df, "key").join(df, "key");
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x6;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    return (B1)reusedExchangeExec;
                }
                return (B1)function1.apply(x6);
            }

            public final boolean isDefinedAt(SparkPlan x6) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x6;
                return sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
            }
        });
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        Seq $org_scalatest_assert_macro_left2 = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x7;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x7);
            }

            public final boolean isDefinedAt(SparkPlan x7) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x7;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        Dataset grouped = df.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)1)).as("key")})).agg(functions$.MODULE$.max("value").as("value"), (Seq)Nil$.MODULE$);
        Dataset resultDf2 = grouped.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)1))})).max((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).union(grouped.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("key").$plus((Object)BoxesRunTime.boxToInteger((int)2))})).max((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)}));
        Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)}));
        Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)}));
        Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1)}));
        Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)}));
        Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2)}));
        Row row7 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3)}));
        Row row8 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3)}));
        Row row9 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)4)}));
        Row row10 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)4)}));
        Row row11 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)5)}));
        Row row12 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)5)}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf2, (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row12).$colon$colon((Object)row11).$colon$colon((Object)row10).$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan2 = ((AdaptiveSparkPlanExec)resultDf2.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left3 = level1Stages = finalPlan2.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                A1 A1 = x8;
                if (A1 instanceof QueryStageExec) {
                    QueryStageExec queryStageExec = (QueryStageExec)A1;
                    return (B1)queryStageExec;
                }
                return (B1)function1.apply(x8);
            }

            public final boolean isDefinedAt(SparkPlan x8) {
                SparkPlan sparkPlan2 = x8;
                return sparkPlan2 instanceof QueryStageExec;
            }
        });
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        Seq $org_scalatest_assert_macro_left4 = finalPlan2.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x9;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x9);
            }

            public final boolean isDefinedAt(SparkPlan x9) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x9;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"finalPlan2", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        level1Stages.foreach((Function1 & Serializable)qs -> {
            Seq $org_scalatest_assert_macro_left = qs.plan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    A1 A1 = x10;
                    if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                        return (B1)aQEShuffleReadExec;
                    }
                    return (B1)function1.apply(x10);
                }

                public final boolean isDefinedAt(SparkPlan x10) {
                    AQEShuffleReadExec aQEShuffleReadExec;
                    SparkPlan sparkPlan2 = x10;
                    return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
                }
            });
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Wrong CoalescedShuffleRead below " + qs.simpleString(3)), Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        });
        Seq $org_scalatest_assert_macro_left5 = leafStages = (Seq)level1Stages.flatMap((Function1 & Serializable)stage -> {
            Seq children;
            Seq $org_scalatest_assert_macro_left = children = stage.plan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    A1 A1 = x11;
                    if (A1 instanceof QueryStageExec) {
                        QueryStageExec queryStageExec = (QueryStageExec)A1;
                        return (B1)queryStageExec;
                    }
                    return (B1)function1.apply(x11);
                }

                public final boolean isDefinedAt(SparkPlan x11) {
                    SparkPlan sparkPlan2 = x11;
                    return sparkPlan2 instanceof QueryStageExec;
                }
            });
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            return children;
        });
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        Seq $org_scalatest_assert_macro_left6 = reusedStages = (Seq)level1Stages.flatMap((Function1 & Serializable)stage -> stage.plan().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                A1 A1 = x12;
                if (A1 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)A1).plan()) instanceof ReusedExchangeExec) {
                    ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)r;
                    return (B1)reusedExchangeExec;
                }
                return (B1)function1.apply(x12);
            }

            public final boolean isDefinedAt(SparkPlan x12) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan r;
                SparkPlan sparkPlan2 = x12;
                return sparkPlan2 instanceof ShuffleQueryStageExec && (r = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan2).plan()) instanceof ReusedExchangeExec;
            }
        }));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }

    public static final /* synthetic */ void $anonfun$new$23(SparkSession spark) {
        Dataset ds = spark.range(3L);
        Dataset resultDf = ds.repartition(2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ds.col("id")})).toDF();
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x13;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x13);
            }

            public final boolean isDefinedAt(SparkPlan x13) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x13;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
    }

    public static final /* synthetic */ void $anonfun$new$26(SparkSession spark) {
        Dataset df1 = spark.range(3L).join(spark.range(3L), "id").toDF();
        Dataset df2 = spark.range(3L).groupBy((Seq)Nil$.MODULE$).sum((Seq)Nil$.MODULE$);
        Dataset resultDf = df1.union(df2);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)resultDf, (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})))), QueryTest$.MODULE$.checkAnswer$default$3());
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Seq $org_scalatest_assert_macro_left = finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x14;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x14);
            }

            public final boolean isDefinedAt(SparkPlan x14) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x14;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        });
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
    }

    public static final /* synthetic */ void $anonfun$new$29(CoalesceShufflePartitionsSuite $this, SparkSession spark) {
        Dataset ds = spark.range(0L, 100L, 1L, $this.numInputPartitions());
        Dataset resultDf = ds.repartition((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{ds.col("id")}));
        resultDf.collect();
        SparkPlan finalPlan = ((AdaptiveSparkPlanExec)resultDf.queryExecution().executedPlan()).executedPlan();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(finalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                AQEShuffleReadExec aQEShuffleReadExec;
                A1 A1 = x15;
                if (A1 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)A1)) {
                    return (B1)aQEShuffleReadExec;
                }
                return (B1)function1.apply(x15);
            }

            public final boolean isDefinedAt(SparkPlan x15) {
                AQEShuffleReadExec aQEShuffleReadExec;
                SparkPlan sparkPlan2 = x15;
                return sparkPlan2 instanceof AQEShuffleReadExec && CoalescedShuffleRead$.MODULE$.unapply(aQEShuffleReadExec = (AQEShuffleReadExec)sparkPlan2);
            }
        }).isDefinedAt(0), "finalPlan.collect[org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec](({\n  @SerialVersionUID(value = 0) final <synthetic> class $anonfun extends scala.runtime.AbstractPartialFunction[org.apache.spark.sql.execution.SparkPlan,org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec] with java.io.Serializable {\n    def <init>(): <$anon: org.apache.spark.sql.execution.SparkPlan => org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec> = {\n      $anonfun.super.<init>();\n      ()\n    };\n    final override def applyOrElse[A1 <: org.apache.spark.sql.execution.SparkPlan, B1 >: org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec](x15: A1, default: A1 => B1): B1 = ((x15.asInstanceOf[org.apache.spark.sql.execution.SparkPlan]: org.apache.spark.sql.execution.SparkPlan): org.apache.spark.sql.execution.SparkPlan @unchecked) match {\n      case (r @ CoalescedShuffleRead.unapply(<unapply-selector>) <unapply> ()) => r\n      case (defaultCase$ @ _) => default.apply(x15)\n    };\n    final def isDefinedAt(x15: org.apache.spark.sql.execution.SparkPlan): Boolean = ((x15.asInstanceOf[org.apache.spark.sql.execution.SparkPlan]: org.apache.spark.sql.execution.SparkPlan): org.apache.spark.sql.execution.SparkPlan @unchecked) match {\n      case (r @ CoalescedShuffleRead.unapply(<unapply-selector>) <unapply> ()) => true\n      case (defaultCase$ @ _) => false\n    }\n  };\n  new $anonfun()\n}: PartialFunction[org.apache.spark.sql.execution.SparkPlan,org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec])).isDefinedAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
    }

    public CoalesceShufflePartitionsSuite() {
        this.numInputPartitions = 10;
        new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)minNumPostShufflePartitions -> {
            CoalesceShufflePartitionsSuite.$anonfun$new$1(this, minNumPostShufflePartitions);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-24705 adaptive query execution works correctly when exchange reuse enabled", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$17(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 400, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("Do not reduce the number of shuffle partition for repartition", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$23(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 200, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("Union two datasets with different pre-shuffle partition number", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$26(spark);
                return BoxedUnit.UNIT;
            };
            this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, 100, (Option<Object>)None$.MODULE$, this.withSparkSession$default$4());
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("SPARK-34790: enable IO encryption in AQE partition coalescing", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function1 & Serializable test = (Function1 & Serializable)spark -> {
                CoalesceShufflePartitionsSuite.$anonfun$new$29(this, spark);
                return BoxedUnit.UNIT;
            };
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enableIOEncryption -> {
                this.withSparkSession((Function1<SparkSession, BoxedUnit>)test, Integer.MAX_VALUE, (Option<Object>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)enableIOEncryption));
                return BoxedUnit.UNIT;
            });
        }, new Position("CoalesceShufflePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
    }
}

