/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.ExtendedAnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.columnar.CachedRDDBuilder;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0015g!B\u0014)\u0003\u0003\t\u0004\"\u0002 \u0001\t\u0003y\u0004\"B\u0016\u0001\r#\u0011\u0005\"\u0002$\u0001\t\u00039\u0005\"B4\u0001\t\u0003A\u0007\"B6\u0001\t#a\u0007bBA\u0005\u0001\u0011E\u00111\u0002\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\tI\u0005\u0001C\t\u0003\u0017Bq!!\u0013\u0001\t#\ty\u0006C\u0004\u0002J\u0001!\t\"!\u001a\t\u000f\u0005%\u0003\u0001\"\u0005\u0002l!9\u00111\u000f\u0001\u0005\u0012\u0005U\u0004bBA:\u0001\u0011E\u0011q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011%\tY\u000bAI\u0001\n\u0003\ti\u000bC\u0004\u0002\u0010\u0002!\t!a1\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u0011Q\u001f\u0001\u0005\u0012\u0005]\bbBA}\u0001\u0011E\u00111 \u0005\n\u0005\u0003\u0001\u0011\u0013!C\t\u0003[;qAa\u0001)\u0011\u0003\u0011)A\u0002\u0004(Q!\u0005!q\u0001\u0005\u0007}Y!\tAa\u000b\t\u000f\u0005%c\u0003\"\u0001\u0003.!I!Q\b\f\u0012\u0002\u0013\u0005!q\b\u0005\b\u0005\u00072B\u0011\u0001B#\u0011%\u0011\u0019FFI\u0001\n\u0003\u0011y\u0004C\u0004\u0003VY!\tAa\u0016\t\u000f\t\u0005d\u0003\"\u0001\u0003d!9!\u0011\u000e\f\u0005\n\t-\u0004\"\u0003B;-E\u0005I\u0011\u0002B \u0011\u001d\u00119H\u0006C\u0001\u0005sBqA!!\u0017\t\u0003\u0011\u0019\tC\u0004\u0003\u000eZ!\tAa$\t\u0013\t]e#%A\u0005\u0002\t}\u0002bBA:-\u0011E!\u0011\u0014\u0005\b\u0003\u00132B\u0011\u0001BR\u0011%\u0011)LFA\u0001\n\u0013\u00119LA\u0005Rk\u0016\u0014\u0018\u0010V3ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\r\u001c\u0011\u0005M\"T\"\u0001\u0016\n\u0005UR#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005)\u0001\u000f\\1og*\u00111\bK\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\b\u000f\u0002\t!2\fg\u000eV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u0011\t\u0003\u0003\u0002i\u0011\u0001K\u000b\u0002\u0007B\u0011\u0011\tR\u0005\u0003\u000b\"\u0012Ab\u00159be.\u001cVm]:j_:\f!c\u00195fG.\\U-_<pe\u0012\u001cX\t_5tiR\u0019\u0001JT,\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u0003I\u001a\u0004\"!\u0015+\u000f\u0005\u0005\u0013\u0016BA*)\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA*)\u0011\u0015A6\u00011\u0001Z\u0003!YW-_<pe\u0012\u001c\bcA%[9&\u00111L\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CA/e\u001d\tq&\r\u0005\u0002`\u00156\t\u0001M\u0003\u0002ba\u00051AH]8pizJ!a\u0019&\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G*\u000bQc\u00195fG.\\U-_<pe\u0012\u001chj\u001c;Fq&\u001cH\u000fF\u0002IS*DQa\u0014\u0003A\u0002ACQ\u0001\u0017\u0003A\u0002e\u000bAb\u00195fG.$\u0015\r^1tKR,\"!\u001c=\u0015\t!s\u00171\u0001\u0005\u0007_\u0016!\t\u0019\u00019\u0002\u0005\u0011\u001c\bcA%rg&\u0011!O\u0013\u0002\ty\tLh.Y7f}A\u0019\u0011\t\u001e<\n\u0005UD#a\u0002#bi\u0006\u001cX\r\u001e\t\u0003obd\u0001\u0001B\u0003z\u000b\t\u0007!PA\u0001U#\tYh\u0010\u0005\u0002Jy&\u0011QP\u0013\u0002\b\u001d>$\b.\u001b8h!\tIu0C\u0002\u0002\u0002)\u00131!\u00118z\u0011\u001d\t)!\u0002a\u0001\u0003\u000f\ta\"\u001a=qK\u000e$X\rZ!og^,'\u000fE\u0002J5Z\fQc\u00195fG.$\u0015\r^1tKR,fn\u001c:eKJd\u00170\u0006\u0003\u0002\u000e\u0005\u001dBCBA\b\u0003S\ty\u0003F\u0002I\u0003#A\u0011\"a\u0005\u0007\u0003\u0003\u0005\u001d!!\u0006\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002\u0018\u0005}\u0011Q\u0005\b\u0005\u00033\tiBD\u0002`\u00037I\u0011aS\u0005\u0003'*KA!!\t\u0002$\tAqJ\u001d3fe&twM\u0003\u0002T\u0015B\u0019q/a\n\u0005\u000be4!\u0019\u0001>\t\u000f=4A\u00111\u0001\u0002,A!\u0011*]A\u0017!\u0011\tE/!\n\t\u000f\u0005\u0015a\u00011\u0001\u00022A!\u0011JWA\u0013\u0003%9W\r\u001e*fgVdG/\u0006\u0003\u00028\u0005\u0005C\u0003BA\u001d\u0003\u0007\u0002R!SA\u001e\u0003\u007fI1!!\u0010K\u0005\u0015\t%O]1z!\r9\u0018\u0011\t\u0003\u0006s\u001e\u0011\rA\u001f\u0005\b_\u001e!\t\u0019AA#!\u0011I\u0015/a\u0012\u0011\t\u0005#\u0018qH\u0001\fG\",7m[!og^,'\u000fF\u0003I\u0003\u001b\n\t\u0006C\u0004P\u0011\u0011\u0005\r!a\u0014\u0011\u0007%\u000b\b\u000bC\u0004\u0002\u0006!\u0001\r!a\u0015\u0011\r\u0005]\u0011QKA-\u0013\u0011\t9&a\t\u0003\u0007M+\u0017\u000fE\u0002B\u00037J1!!\u0018)\u0005\r\u0011vn\u001e\u000b\u0006\u0011\u0006\u0005\u00141\r\u0005\b\u001f&!\t\u0019AA(\u0011\u001d\t)!\u0003a\u0001\u00033\"R\u0001SA4\u0003SBqa\u0014\u0006\u0005\u0002\u0004\ty\u0005\u0003\u0004\u0002\u0006)\u0001\r\u0001\u0015\u000b\u0006\u0011\u00065\u0014q\u000e\u0005\b\u001f.!\t\u0019AA(\u0011\u001d\t)a\u0003a\u0001\u0003c\u0002R!SA\u001e\u00033\nac\u00195fG.\fum\u001a:fO\u0006$Xm],ji\"$v\u000e\u001c\u000b\b\u0011\u0006]\u00141PA?\u0011\u0019\tI\b\u0004a\u0001!\u0006IA-\u0019;b\rJ\fW.\u001a\u0005\b\u0003\u000ba\u0001\u0019AA*\u0011\u001d\ty\b\u0004a\u0001\u0003\u0003\u000ba!\u00192t)>d\u0007cA%\u0002\u0004&\u0019\u0011Q\u0011&\u0003\r\u0011{WO\u00197f)\u001dA\u0015\u0011RAF\u0003\u001bCa!!\u001f\u000e\u0001\u0004\u0001\u0006bBA\u0003\u001b\u0001\u0007\u0011\u0011\f\u0005\b\u0003\u007fj\u0001\u0019AAA\u00031\t7o]3si\u000e\u000b7\r[3e)\u0015A\u00151SAQ\u0011\u001d\t)J\u0004a\u0001\u0003/\u000bQ!];fef\u0004D!!'\u0002\u001eB!\u0011\t^AN!\r9\u0018Q\u0014\u0003\f\u0003?\u000b\u0019*!A\u0001\u0002\u000b\u0005!PA\u0002`IEB\u0011\"a)\u000f!\u0003\u0005\r!!*\u0002\u001f9,XnQ1dQ\u0016$G+\u00192mKN\u00042!SAT\u0013\r\tIK\u0013\u0002\u0004\u0013:$\u0018AF1tg\u0016\u0014HoQ1dQ\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005=&\u0006BAS\u0003c[#!a-\u0011\t\u0005U\u0016qX\u0007\u0003\u0003oSA!!/\u0002<\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{S\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011YA\\\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\b\u0011\u0006\u0015\u0017\u0011[Ak\u0011\u001d\t)\n\u0005a\u0001\u0003\u000f\u0004D!!3\u0002NB!\u0011\t^Af!\r9\u0018Q\u001a\u0003\f\u0003\u001f\f)-!A\u0001\u0002\u000b\u0005!PA\u0002`IIBa!a5\u0011\u0001\u0004a\u0016AC2bG\",GMT1nK\"9\u0011q\u001b\tA\u0002\u0005e\u0017\u0001D:u_J\fw-\u001a'fm\u0016d\u0007\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}'&A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0018Q\u001c\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0001\u0018CN\u001cXM\u001d;F[B$\u00180T5tg&tw-\u00138qkR$2\u0001SAu\u0011\u001d\t)*\u0005a\u0001\u0003W\u0004D!!<\u0002rB!\u0011\t^Ax!\r9\u0018\u0011\u001f\u0003\f\u0003g\fI/!A\u0001\u0002\u000b\u0005!PA\u0002`IM\nadZ3u\u0007V\u0014(/\u001a8u\u00072\f7o]\"bY2\u001c\u0016\u000e^3QCR$XM\u001d8\u0016\u0003q\u000b!dZ3u\u001d\u0016DH\u000fT5oK\u000e\u000bG\u000e\\*ji\u0016\u0004\u0016\r\u001e;fe:$2\u0001XA\u007f\u0011%\typ\u0005I\u0001\u0002\u0004\t)+A\u0003mS:,7/\u0001\u0013hKRtU\r\u001f;MS:,7)\u00197m'&$X\rU1ui\u0016\u0014h\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002B-M9aC!\u0003\u0003\u0010\tm\u0001cA%\u0003\f%\u0019!Q\u0002&\u0003\r\u0005s\u0017PU3g!\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b]\u0005I1oY1mCR,7\u000f^\u0005\u0005\u00053\u0011\u0019B\u0001\u0006BgN,'\u000f^5p]N\u0004BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#\u0001\u0002j_*\u0011!QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003*\t}!\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u0003)\u001dA%q\u0006B\u0019\u0005gAQa\u0014\rA\u0002ACq!!\u0002\u0019\u0001\u0004\t\u0019\u0006C\u0005\u00036a\u0001\n\u00111\u0001\u00038\u0005Q1\r[3dWR{'\u000b\u0012#\u0011\u0007%\u0013I$C\u0002\u0003<)\u0013qAQ8pY\u0016\fg.A\u000bdQ\u0016\u001c7.\u00118to\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005#\u0006\u0002B\u001c\u0003c\u000bAdZ3u\u000bJ\u0014xN]'fgN\fw-Z%o\u0007\",7m[!og^,'\u000f\u0006\u0005\u0003H\t5#q\nB)!\u0011I%\u0011\n/\n\u0007\t-#J\u0001\u0004PaRLwN\u001c\u0005\u0006\u001fj\u0001\r\u0001\u0015\u0005\b\u0003\u000bQ\u0002\u0019AA*\u0011%\u0011)D\u0007I\u0001\u0002\u0004\u00119$\u0001\u0014hKR,%O]8s\u001b\u0016\u001c8/Y4f\u0013:\u001c\u0005.Z2l\u0003:\u001cx/\u001a:%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:fa\u0006\u0014X-\u00118to\u0016\u0014HCBA*\u00053\u0012i\u0006C\u0004\u0003\\q\u0001\r!a\u0015\u0002\r\u0005t7o^3s\u0011\u001d\u0011y\u0006\ba\u0001\u0005o\t\u0001\"[:T_J$X\rZ\u0001\u000baJ,\u0007/\u0019:f%><H\u0003BA-\u0005KBqAa\u001a\u001e\u0001\u0004\tI&A\u0002s_^\f\u0001bZ3o\u000bJ\u0014xN\u001d\u000b\b9\n5$q\u000eB:\u0011\u001d\t)A\ba\u0001\u0003'BqA!\u001d\u001f\u0001\u0004\t\u0019&A\u0006ta\u0006\u00148.\u00118to\u0016\u0014\b\"\u0003B0=A\u0005\t\u0019\u0001B\u001c\u0003I9WM\\#se>\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019%t7\r\\;eKN\u0014vn^:\u0015\r\t\u001d#1\u0010B@\u0011\u001d\u0011i\b\ta\u0001\u0003'\nA\"\u001a=qK\u000e$X\r\u001a*poNDqA!\u001d!\u0001\u0004\t\u0019&A\u0004d_6\u0004\u0018M]3\u0015\r\t]\"Q\u0011BE\u0011\u0019\u00119)\ta\u0001}\u0006!qN\u001962\u0011\u0019\u0011Y)\ta\u0001}\u0006!qN\u001963\u0003!\u0019\u0018-\\3S_^\u001cH\u0003\u0003B$\u0005#\u0013\u0019J!&\t\u000f\u0005\u0015!\u00051\u0001\u0002T!9!\u0011\u000f\u0012A\u0002\u0005M\u0003\"\u0003B0EA\u0005\t\u0019\u0001B\u001c\u0003I\u0019\u0018-\\3S_^\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0015\u000f!\u0013YJa(\u0003\"\"9!Q\u0014\u0013A\u0002\u0005e\u0013\u0001D1diV\fG.\u00118to\u0016\u0014\bbBA\u0003I\u0001\u0007\u0011\u0011\f\u0005\b\u0003\u007f\"\u0003\u0019AAA)\u0015A%Q\u0015BT\u0011\u0015yU\u00051\u0001Q\u0011\u001d\t)!\na\u0001\u0005S\u0003bAa+\u00032\u0006eSB\u0001BW\u0015\u0011\u0011yKa\t\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005g\u0013iK\u0001\u0003MSN$\u0018\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B]!\u0011\u0011YL!1\u000e\u0005\tu&\u0002\u0002B`\u0005G\tA\u0001\\1oO&!!1\u0019B_\u0005\u0019y%M[3di\u0002")
public abstract class QueryTest
extends SparkFunSuite
implements PlanTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public static boolean sameRows$default$3() {
        return QueryTest$.MODULE$.sameRows$default$3();
    }

    public static Option<String> sameRows(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        return QueryTest$.MODULE$.sameRows(expectedAnswer, sparkAnswer, isSorted);
    }

    public static boolean compare(Object obj1, Object obj2) {
        return QueryTest$.MODULE$.compare(obj1, obj2);
    }

    public static Option<String> includesRows(Seq<Row> expectedRows, Seq<Row> sparkAnswer) {
        return QueryTest$.MODULE$.includesRows(expectedRows, sparkAnswer);
    }

    public static Row prepareRow(Row row) {
        return QueryTest$.MODULE$.prepareRow(row);
    }

    public static Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        return QueryTest$.MODULE$.prepareAnswer(answer, isSorted);
    }

    public static boolean getErrorMessageInCheckAnswer$default$3() {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer$default$3();
    }

    public static Option<String> getErrorMessageInCheckAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer(df, expectedAnswer, checkToRDD);
    }

    public static boolean checkAnswer$default$3() {
        return QueryTest$.MODULE$.checkAnswer$default$3();
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        QueryTest queryTest = this;
        synchronized (queryTest) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public abstract SparkSession spark();

    public void checkKeywordsExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$1 -> x$1.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Failed for " + df + " (" + key + " doesn't exist in result)"), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        });
    }

    public void checkKeywordsNotExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$2 -> x$2.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Failed for " + df + " (" + key + " existed in the result)"), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        });
    }

    public <T> void checkDataset(Function0<Dataset<T>> ds, Seq<T> expectedAnswer) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)), expectedAnswer)) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |Decoded objects do not match expected objects:\n           |expected: " + expectedAnswer + "\n           |actual:   " + ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)) + "\n           |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n         ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }
    }

    public <T> void checkDatasetUnorderly(Function0<Dataset<T>> ds, Seq<T> expectedAnswer, Ordering<T> evidence$1) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)).sorted(evidence$1), expectedAnswer.sorted(evidence$1))) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |Decoded objects do not match expected objects:\n           |expected: " + expectedAnswer + "\n           |actual:   " + ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)) + "\n           |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n         ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }
    }

    private <T> Object getResult(Function0<Dataset<T>> ds) {
        Object object;
        Dataset dataset;
        try {
            dataset = (Dataset)ds.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |Failed to analyze query: " + ae + "\n               |" + ae.plan().get() + "\n               |\n               |" + package$.MODULE$.stackTraceToString((Throwable)ae) + "\n             ")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            }
            throw ae;
        }
        Dataset analyzedDS = dataset;
        this.assertEmptyMissingInput(analyzedDS);
        try {
            object = ((Dataset)ds.apply()).collect();
        }
        catch (Exception e) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |Exception collecting dataset as objects\n             |" + ((Dataset)ds.apply()).exprEnc() + "\n             |" + ((Dataset)ds.apply()).exprEnc().deserializer().treeString() + "\n             |" + ((Dataset)ds.apply()).queryExecution() + "\n           ")), e, new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }
        return object;
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Seq<Row> expectedAnswer) {
        Dataset dataset;
        try {
            dataset = (Dataset)df.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |Failed to analyze query: " + ae + "\n               |" + ae.plan().get() + "\n               |\n               |" + package$.MODULE$.stackTraceToString((Throwable)ae) + "\n               |")), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }
            throw ae;
        }
        Dataset analyzedDF = dataset;
        this.assertEmptyMissingInput(analyzedDF);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)analyzedDF, expectedAnswer, QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Row expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)new .colon.colon((Object)expectedAnswer, (List)Nil$.MODULE$));
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Dataset<Row> expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps(expectedAnswer.collect()).toImmutableArraySeq());
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Row[] expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)expectedAnswer).toImmutableArraySeq());
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Seq<Row> expectedAnswer, double absTol) {
        Row[] actualAnswer = (Row[])dataFrame.collect();
        Predef$.MODULE$.require(actualAnswer.length == expectedAnswer.length(), (Function0 & Serializable)() -> "actual num rows " + actualAnswer.length + " != expected num of rows " + expectedAnswer.length());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])actualAnswer), expectedAnswer)), (Function1 & Serializable)x0$1 -> {
            QueryTest.$anonfun$checkAggregatesWithTol$2(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Row expectedAnswer, double absTol) {
        this.checkAggregatesWithTol(dataFrame, (Seq<Row>)new .colon.colon((Object)expectedAnswer, (List)Nil$.MODULE$), absTol);
    }

    public void assertCached(Dataset<?> query, int numCachedTables) {
        Seq cachedData;
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        Seq $org_scalatest_assert_macro_left = cachedData = planWithCaching.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryRelation) {
                    InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                    return (B1)inMemoryRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof InMemoryRelation;
            }
        });
        int $org_scalatest_assert_macro_right = numCachedTables;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected query to contain " + numCachedTables + ", but it actually had " + cachedData.size() + "\n" + planWithCaching), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }

    public void assertCached(Dataset<?> query, String cachedName, StorageLevel storageLevel) {
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        boolean matched = planWithCaching.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QueryTest.$anonfun$assertCached$1(cachedName, storageLevel, x0$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(matched, "matched", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected query plan to hit cache " + cachedName + " with storage level " + storageLevel + ", but it doesn't."), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
    }

    public int assertCached$default$2() {
        return 1;
    }

    public void assertEmptyMissingInput(Dataset<?> query) {
        AttributeSet $org_scalatest_assert_macro_left = query.queryExecution().analyzed().missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("The analyzed logical plan has missing inputs:\n" + query.queryExecution().analyzed()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        AttributeSet $org_scalatest_assert_macro_left2 = query.queryExecution().optimizedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("The optimized logical plan has missing inputs:\n" + query.queryExecution().optimizedPlan()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        AttributeSet $org_scalatest_assert_macro_left3 = query.queryExecution().executedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)("The physical plan has missing inputs:\n" + query.queryExecution().executedPlan()), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
    }

    public String getCurrentClassCallSitePattern() {
        StackTraceElement cs = Thread.currentThread().getStackTrace()[2];
        return cs.getClassName() + "\\..*\\(" + cs.getFileName() + ":\\d+\\)";
    }

    public String getNextLineCallSitePattern(int lines) {
        StackTraceElement cs = Thread.currentThread().getStackTrace()[2];
        return Pattern.quote(cs.getClassName() + "." + cs.getMethodName() + "(" + cs.getFileName() + ":" + (cs.getLineNumber() + lines) + ")");
    }

    public int getNextLineCallSitePattern$default$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$2(double absTol$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Row actualRow = (Row)tuple2._1();
            Row expectedRow = (Row)tuple2._2();
            QueryTest$.MODULE$.checkAggregatesWithTol(actualRow, expectedRow, absTol$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$assertCached$1(String cachedName$1, StorageLevel storageLevel$1, LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (!(logicalPlan instanceof InMemoryRelation)) return false;
        InMemoryRelation inMemoryRelation = (InMemoryRelation)logicalPlan;
        CachedRDDBuilder cacheBuilder = inMemoryRelation.cacheBuilder();
        String string = cachedName$1;
        Object object = cacheBuilder.tableName().get();
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        StorageLevel storageLevel = storageLevel$1;
        StorageLevel storageLevel2 = cacheBuilder.storageLevel();
        if (storageLevel == null) {
            if (storageLevel2 == null) return true;
            return false;
        } else {
            if (!storageLevel.equals(storageLevel2)) return false;
            return true;
        }
    }

    public QueryTest() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
    }
}

